/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.text.I18n;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.ServerAnimationState;
import java.util.Locale;

public enum VanillaPose implements IPose
{
    CUSTOM,
    STANDING,
    WALKING,
    RUNNING,
    SNEAKING,
    SWIMMING,
    FALLING,
    SLEEPING,
    RIDING,
    FLYING,
    DYING,
    SKULL_RENDER,
    GLOBAL,
    CREATIVE_FLYING,
    EATING_LEFT,
    EATING_RIGHT,
    RETRO_SWIMMING,
    JUMPING,
    SNEAK_WALK,
    PUNCH_LEFT(s -> s.attackTime),
    PUNCH_RIGHT(s -> s.attackTime),
    ARMOR_HEAD,
    ARMOR_BODY,
    ARMOR_LEGS,
    ARMOR_BOOTS,
    WEARING_ELYTRA,
    BOW_LEFT(s -> s.bowPullback),
    BOW_RIGHT(s -> s.bowPullback),
    CROSSBOW_LEFT,
    CROSSBOW_RIGHT,
    CROSSBOW_CH_LEFT(s -> s.crossbowPullback),
    CROSSBOW_CH_RIGHT(s -> s.crossbowPullback),
    TRIDENT_LEFT,
    TRIDENT_RIGHT,
    TRIDENT_SPIN,
    SPYGLASS_LEFT,
    SPYGLASS_RIGHT,
    HOLDING_LEFT,
    HOLDING_RIGHT,
    WEARING_SKULL,
    BLOCKING_LEFT,
    BLOCKING_RIGHT,
    PARROT_LEFT,
    PARROT_RIGHT,
    HURT,
    ON_FIRE,
    FREEZING,
    ON_LADDER,
    CLIMBING_ON_LADDER,
    SPEAKING(s -> s.speakLevel),
    TOOT_HORN_LEFT,
    TOOT_HORN_RIGHT,
    IN_GUI,
    FIRST_PERSON_MOD,
    VOICE_MUTED,
    VR_FIRST_PERSON,
    VR_THIRD_PERSON_SITTING,
    VR_THIRD_PERSON_STANDING,
    FIRST_PERSON_HAND,
    HEALTH(VanillaPose.syncedState(s -> s.health)),
    HUNGER(VanillaPose.syncedState(s -> s.hunger)),
    AIR(VanillaPose.syncedState(s -> s.air)),
    IN_MENU,
    INVISIBLE,
    LIGHT(s -> (float)Math.max(s.skyLight, s.blockLight) / 15.0f),
    HEAD_ROTATION_YAW(VanillaPose::calcHeadYaw),
    HEAD_ROTATION_PITCH(s -> MathHelper.clamp((s.pitch + 90.0f) / 180.0f, 0.0f, 1.0f)),
    BRUSH_LEFT,
    BRUSH_RIGHT,
    CRAWLING;

    private final String i18nKey = "label.cpm.pose." + this.name().toLowerCase(Locale.ROOT);
    private ToFloatFunction<AnimationState> stateGetter;
    public static final VanillaPose[] VALUES;
    public static final int DYNAMIC_DURATION_MUL = 1000;
    public static final int DYNAMIC_DURATION_DIV = 1001;

    private VanillaPose() {
    }

    private static ToFloatFunction<AnimationState> syncedState(ToFloatFunction<ServerAnimationState> state) {
        return s -> {
            if (s.serverState.updated) {
                return state.apply(s.serverState);
            }
            return state.apply(s.localState);
        };
    }

    private static float calcHeadYaw(AnimationState s) {
        double ccd;
        double cd;
        float d;
        float bodyYaw;
        float yaw = s.yaw % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((bodyYaw = s.bodyYaw % 360.0f) < 0.0f) {
            bodyYaw += 360.0f;
        }
        if ((d = Math.abs(yaw - bodyYaw)) > 180.0f) {
            d = 360.0f - d;
        }
        if ((cd = ((double)(bodyYaw - yaw) + 360.0) % 360.0) < (ccd = ((double)(yaw - bodyYaw) + 360.0) % 360.0)) {
            d = -d;
        }
        return MathHelper.clamp((d + 90.0f) / 180.0f, 0.0f, 1.0f);
    }

    private VanillaPose(ToFloatFunction<AnimationState> stateGetter) {
        this();
        this.stateGetter = stateGetter;
    }

    @Override
    public String getName(I18n gui, String display) {
        if (display == null) {
            return gui.i18nFormat(this.i18nKey, new Object[0]);
        }
        return gui.i18nFormat("label.cpm.vanilla_anim", gui.i18nFormat(this.i18nKey, new Object[0]), display);
    }

    @Override
    public long getTime(AnimationState state, long time) {
        if (this.stateGetter != null && state != null) {
            return (long)(this.stateGetter.apply(state) * 1000.0f);
        }
        return time;
    }

    public boolean hasStateGetter() {
        return this.stateGetter != null;
    }

    static {
        VALUES = VanillaPose.values();
    }
}

