/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BiomeHandler;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.common.PlatformCommon;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.MinecraftServerAccess;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BiomeHandlerImpl
extends BiomeHandler<WorldImpl.BiomeInfo> {
    public static final BiomeHandlerImpl clientImpl = new BiomeHandlerImpl(() -> Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_));
    public static final BiomeHandlerImpl serverImpl = new BiomeHandlerImpl(() -> ((MinecraftServerObject)MinecraftServerAccess.get()).getServer().m_206579_().m_175515_(Registries.f_256952_));
    private static final BlockPos SEA_LEVEL = new BlockPos(0, 64, 0);
    private final Supplier<Registry<Biome>> registry;

    public static BiomeHandlerImpl getImpl(Level level) {
        return level.f_46443_ ? clientImpl : serverImpl;
    }

    public BiomeHandlerImpl(Supplier<Registry<Biome>> registry) {
        this.registry = registry;
    }

    @Override
    public List<com.tom.cpl.block.Biome> listNativeEntries(String tag) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)tag);
        if (rl == null) {
            return Collections.emptyList();
        }
        Holder b = this.registry.get().m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl)).orElse(null);
        if (b != null) {
            return Collections.singletonList(this.wrap(new WorldImpl.BiomeInfo((Holder<Biome>)b, SEA_LEVEL)));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listNativeTags() {
        return this.registry.get().m_203613_().map(k -> k.f_203868_().toString()).toList();
    }

    @Override
    public com.tom.cpl.block.Biome emptyObject() {
        return this.wrap(null);
    }

    @Override
    public boolean isInTag(String tag, WorldImpl.BiomeInfo state) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.m_135820_((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl);
                return state.biome().m_203656_(i);
            }
        } else {
            return this.getBiomeId(state).equals(tag);
        }
        return false;
    }

    @Override
    public List<String> listTags(WorldImpl.BiomeInfo state) {
        return state.biome().m_203616_().map(k -> "#" + k.f_203868_()).toList();
    }

    @Override
    public List<com.tom.cpl.block.Biome> getAllElements() {
        return StreamSupport.stream(this.registry.get().m_206115_().spliterator(), false).map(e -> this.wrap(new WorldImpl.BiomeInfo((Holder<Biome>)e, SEA_LEVEL))).collect(Collectors.toList());
    }

    @Override
    public boolean equals(WorldImpl.BiomeInfo a, WorldImpl.BiomeInfo b) {
        return a.value() == b.value();
    }

    @Override
    public String getBiomeId(WorldImpl.BiomeInfo state) {
        return this.registry.get().m_7981_((Object)state.value()).toString();
    }

    @Override
    public float getTemperature(WorldImpl.BiomeInfo state) {
        return state.value().m_47554_();
    }

    @Override
    public float getHumidity(WorldImpl.BiomeInfo state) {
        return PlatformCommon.getClimateSettings(state.value()).f_47683_();
    }

    @Override
    public BiomeHandler.RainType getRainType(WorldImpl.BiomeInfo state) {
        return BiomeHandler.RainType.get(state.value().m_264600_(state.at()).name());
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.registry.get() != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

