/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.modloaders.fabric;

import java.io.File;
import java.nio.file.Path;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.loader.IEnvLoader;
import me.srrapero720.watermedia.api.loader.IMediaLoader;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class FabricModLoader
implements PreLaunchEntrypoint,
IMediaLoader,
IEnvLoader {
    private static final Marker IT = MarkerManager.getMarker((String)"FabricModLoader");
    private static final String NAME = "Fabric";
    private final WaterMedia instance;
    private Path TMP;

    public FabricModLoader() {
        WaterMedia.LOGGER.info(IT, "Starting...");
        this.instance = WaterMedia.getInstance(this);
    }

    public void onPreLaunch() {
        if (this.client()) {
            this.instance.init();
        }
        this.instance.crash();
    }

    @Override
    public boolean development() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean client() {
        return FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    }

    @Override
    public boolean installed(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Path processPath() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path tmpPath() {
        return this.TMP != null ? this.TMP : (this.TMP = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia"));
    }

    @Override
    public boolean tlauncher() {
        String f = new File("").toPath().toAbsolutePath().toString().toLowerCase();
        boolean tlauncher = f.contains("tlauncher");
        boolean atlauncher = f.contains("atlauncher");
        boolean sklauncher = f.contains("sklauncher");
        boolean tlskincape = this.installed("tlskincape");
        return tlskincape || tlauncher && !atlauncher && !sklauncher;
    }
}

