/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core.tools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import me.lib720.madgag.gif.fmsware.GifDecoder;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.core.tools.DataTool;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class JarTool {
    static final Marker IT = MarkerManager.getMarker((String)"Tools");

    public static String readString(ClassLoader loader, String from) {
        try {
            byte[] bytes = DataTool.readAllBytes(JarTool.readResource(loader, from));
            return new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean copyAsset(ClassLoader loader, String origin, Path dest) {
        boolean bl;
        block10: {
            InputStream is = JarTool.readResource(loader, origin);
            try {
                if (is == null) {
                    throw new FileNotFoundException("Resource was not found in " + origin);
                }
                File destParent = dest.getParent().toFile();
                if (!destParent.exists() && !destParent.mkdirs()) {
                    WaterMedia.LOGGER.fatal(IT, "Cannot be created parent directories to {}", (Object)dest.toString());
                }
                Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.fatal(IT, "Failed to extract from (JAR) {} to {} due to unexpected error", (Object)origin, (Object)dest, (Object)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static List<String> readStringList(ClassLoader loader, String path) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JarTool.readResource(loader, path)));){
            result.addAll((Collection)new Gson().fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.fatal(IT, "Exception trying to read JSON from {}", (Object)path, (Object)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage readImage(ClassLoader loader, String path) {
        try (InputStream in = JarTool.readResource(loader, path);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) throw new FileNotFoundException("result of BufferedImage was null");
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading BufferedImage from resources", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder readGif(ClassLoader loader, String path) {
        try (BufferedInputStream in = new BufferedInputStream(JarTool.readResource(loader, path));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading GIF from resources", e);
        }
    }

    public static InputStream readResource(ClassLoader loader, String source) {
        InputStream is = loader.getResourceAsStream(source);
        if (is == null && source.startsWith("/")) {
            is = loader.getResourceAsStream(source.substring(1));
        }
        return is;
    }

    public static String readString(String from) {
        try {
            byte[] bytes = DataTool.readAllBytes(JarTool.readResource(from));
            return new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean copyAsset(String origin, Path dest) {
        boolean bl;
        block10: {
            InputStream is = JarTool.readResource(origin);
            try {
                if (is == null) {
                    throw new FileNotFoundException("Resource was not found in " + origin);
                }
                File destParent = dest.getParent().toFile();
                if (!destParent.exists() && !destParent.mkdirs()) {
                    WaterMedia.LOGGER.fatal(IT, "Cannot be created parent directories to {}", (Object)dest.toString());
                }
                Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    WaterMedia.LOGGER.fatal(IT, "Failed to extract from (JAR) {} to {} due to unexpected error", (Object)origin, (Object)dest, (Object)e);
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public static List<String> readStringList(String path) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(JarTool.readResource(path)));){
            result.addAll((Collection)new Gson().fromJson((Reader)reader, new TypeToken<List<String>>(){}.getType()));
        }
        catch (Exception e) {
            WaterMedia.LOGGER.fatal(IT, "Exception trying to read JSON from {}", (Object)path, (Object)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage readImage(String path) {
        try (InputStream in = JarTool.readResource(path);){
            BufferedImage image = ImageIO.read(in);
            if (image == null) throw new FileNotFoundException("result of BufferedImage was null");
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading BufferedImage from resources", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder readGif(String path) {
        try (BufferedInputStream in = new BufferedInputStream(JarTool.readResource(path));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed loading GIF from resources", e);
        }
    }

    public static InputStream readResource(String source) {
        InputStream is = JarTool.readResource$byClassLoader(source, JarTool.class.getClassLoader());
        if (is == null) {
            is = JarTool.readResource$byClassLoader(source, Thread.currentThread().getContextClassLoader());
        }
        if (is == null) {
            is = JarTool.readResource$byClassLoader(source, ClassLoader.getSystemClassLoader());
        }
        return is;
    }

    private static InputStream readResource$byClassLoader(String source, ClassLoader classLoader) {
        InputStream is = classLoader.getResourceAsStream(source);
        if (is == null && source.startsWith("/")) {
            is = classLoader.getResourceAsStream(source.substring(1));
        }
        return is;
    }
}

