/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;

public class DataTool {
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36 Edg/112.0.1722.68";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    public static <T> List<T> toList(ServiceLoader<T> s) {
        ArrayList<T> r = new ArrayList<T>();
        for (T t : s) {
            r.add(t);
        }
        return r;
    }

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        int n;
        int len = Integer.MAX_VALUE;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = stream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            if (nread < buf.length) {
                buf = Arrays.copyOfRange(buf, 0, nread);
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }
}

