/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import me.lib720.apache.io.file.PathUtils;
import me.lib720.caprica.vlcj.VideoLan4J;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.factory.discovery.NativeDiscovery;
import me.lib720.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.loader.IMediaLoader;
import me.srrapero720.watermedia.core.tools.JarTool;
import me.srrapero720.watermedia.core.tools.exceptions.ReInitException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class VideoLanCore {
    public static final Marker IT = MarkerManager.getMarker((String)VideoLanCore.class.getSimpleName());
    private static MediaPlayerFactory FACTORY;
    private static final NativeDiscovery DISCOVERY;

    public static MediaPlayerFactory factory() {
        return FACTORY;
    }

    public static void init(IMediaLoader loader) throws Exception {
        if (FACTORY != null) {
            throw new ReInitException(VideoLanCore.class.getSimpleName());
        }
        Path dir = loader.tmpPath();
        Path logs = dir.toAbsolutePath().resolve("logs/videolan.log");
        if (Files.exists(logs, new LinkOption[0])) {
            VideoLanCore.init$clearLogsFile(logs);
        }
        VideoLan4J.init(dir.toAbsolutePath().resolve("videolan/"));
        try {
            FACTORY = VideoLanCore.init$createFactory(VideoLanCore.init$readArguments());
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed to load VLC", (Throwable)e);
        }
    }

    private static String[] init$readArguments() {
        return JarTool.readStringList(VideoLanCore.class.getClassLoader(), "/videolan/arguments.json").toArray(new String[0]);
    }

    private static void init$clearLogsFile(Path logFilePath) {
        Path parent = logFilePath.getParent();
        try {
            PathUtils.deleteDirectory(parent);
        }
        catch (IOException e) {
            WaterMedia.LOGGER.warn(IT, "Failed to delete VLC logs directory", (Throwable)e);
        }
    }

    public static MediaPlayerFactory init$createFactory(String[] vlcArgs) {
        if (DISCOVERY.discover()) {
            MediaPlayerFactory factory = new MediaPlayerFactory(DISCOVERY, vlcArgs);
            WaterMedia.LOGGER.info(IT, "Created new VLC instance from '{}' with args: '{}'", (Object)DISCOVERY.discoveredPath(), (Object)Arrays.toString(vlcArgs));
            Runtime.getRuntime().addShutdownHook(new Thread(factory::release));
            return factory;
        }
        WaterMedia.LOGGER.error(IT, "VLC was not found on your system");
        WaterMedia.LOGGER.fatal(IT, "Cannot create MediaPlayerFactory instance");
        return null;
    }

    static {
        DISCOVERY = new NativeDiscovery(new NativeDiscoveryStrategy[0]);
    }
}

