/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.loader.IMediaLoader;
import me.srrapero720.watermedia.core.tools.exceptions.ReInitException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CacheCore {
    private static final Marker IT = MarkerManager.getMarker((String)CacheCore.class.getSimpleName());
    private static final Map<String, Entry> ENTRIES = new HashMap<String, Entry>();
    private static File dir;
    private static File index;
    private static boolean init;

    public static void init(IMediaLoader modLoader) throws Exception {
        if (init) {
            throw new ReInitException(CacheCore.class.getSimpleName());
        }
        dir = modLoader.tmpPath().toAbsolutePath().resolve("cache/pictures").toFile();
        index = new File(dir, "index");
        WaterMedia.LOGGER.info(IT, "Mounted on path '{}'", (Object)dir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (index.exists()) {
            try (DataInputStream stream = new DataInputStream(new GZIPInputStream(new FileInputStream(index)));){
                int length = stream.readInt();
                for (int i = 0; i < length; ++i) {
                    String url = stream.readUTF();
                    String tag = stream.readUTF();
                    long time = stream.readLong();
                    long expireTime = stream.readLong();
                    Entry entry = new Entry(url, !tag.isEmpty() ? tag : null, time, expireTime);
                    ENTRIES.put(entry.getUrl(), entry);
                }
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Failed to load indexes", (Throwable)e);
            }
        }
        init = true;
    }

    private static boolean refreshAll() {
        boolean bl;
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(index)));
        try {
            out.writeInt(ENTRIES.size());
            for (Map.Entry<String, Entry> mapEntry : ENTRIES.entrySet()) {
                Entry entry = mapEntry.getValue();
                out.writeUTF(entry.getUrl());
                out.writeUTF(entry.getTag() == null ? "" : entry.getTag());
                out.writeLong(entry.getTime());
                out.writeLong(entry.getExpireTime());
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                WaterMedia.LOGGER.error(IT, "Failed to refresh cache index", (Throwable)e);
                return false;
            }
        }
        out.close();
        return bl;
    }

    private static File entry$getFile(String url) {
        return new File(dir, Base64.getEncoder().encodeToString(url.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String url, String tag, long time, long expireTime, byte[] data) {
        Map<String, Entry> map = ENTRIES;
        synchronized (map) {
            Entry entry = new Entry(url, tag, time, expireTime);
            boolean saved = false;
            File file = CacheCore.entry$getFile(entry.url);
            try (OutputStream out = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                out.write(data);
                saved = true;
            }
            catch (Exception e) {
                WaterMedia.LOGGER.error(IT, "Failed to save cache file {}", (Object)url, (Object)e);
            }
            if (saved && CacheCore.refreshAll()) {
                ENTRIES.put(url, entry);
            } else if (file.exists()) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getEntry(String url) {
        Map<String, Entry> map = ENTRIES;
        synchronized (map) {
            return ENTRIES.get(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEntry(Entry fresh) {
        Map<String, Entry> map = ENTRIES;
        synchronized (map) {
            ENTRIES.put(fresh.url, fresh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntry(String url) {
        Map<String, Entry> map = ENTRIES;
        synchronized (map) {
            ENTRIES.remove(url);
            File file = CacheCore.entry$getFile(url);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    static {
        init = false;
    }

    public static final class Entry {
        private final String url;
        private String tag;
        private long time;
        private long expireTime;

        public Entry(String url, String tag, long time, long expireTime) {
            this.url = url;
            this.tag = tag;
            this.time = time;
            this.expireTime = expireTime;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTag() {
            return this.tag;
        }

        public long getTime() {
            return this.time;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public File getFile() {
            return CacheCore.entry$getFile(this.url);
        }
    }
}

