/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import me.lib720.watermod.safety.TryCore;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.loader.IMediaLoader;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.api.url.fixers.special.SpecialFixer;
import me.srrapero720.watermedia.core.tools.DataTool;
import me.srrapero720.watermedia.core.tools.exceptions.ReInitException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class UrlAPI {
    public static final Marker IT = MarkerManager.getMarker((String)"UrlAPI");
    private static final List<URLFixer> FIXERS = new ArrayList<URLFixer>();

    public static URLFixer.Result fixURL(String strUrl) {
        return UrlAPI.fixURL(strUrl, false);
    }

    public static URLFixer.Result fixURL(String strUrl, boolean specials) {
        if (UrlAPI.isValid(strUrl)) {
            return TryCore.withReturn(defaultVar -> {
                URL url = new URL(strUrl);
                if (strUrl.startsWith("file:///") || strUrl.startsWith("local://")) {
                    return new URLFixer.Result(url, false, false);
                }
                for (int i = 0; i < FIXERS.size(); ++i) {
                    URLFixer fixer = FIXERS.get(i);
                    if (fixer instanceof SpecialFixer && !specials || !fixer.isValid(url)) continue;
                    return fixer.patch(url, null);
                }
                return new URLFixer.Result(url, false, false);
            }, e -> WaterMedia.LOGGER.error(IT, "Exception occurred fixing URL", (Throwable)e), null);
        }
        WaterMedia.LOGGER.error(IT, "URL doesn't have a valid syntax, cannot be fixed");
        return null;
    }

    public static String[] getFixersPlatforms() {
        return UrlAPI.getFixersPlatforms(false);
    }

    public static String[] getFixersPlatforms(boolean specials) {
        String[] result = new String[FIXERS.size()];
        for (int i = 0; i < FIXERS.size(); ++i) {
            URLFixer fixer = FIXERS.get(i);
            if (fixer instanceof SpecialFixer && !specials) continue;
            result[i] = fixer.platform();
        }
        return result;
    }

    public static boolean isValid(String url) {
        return TryCore.withReturn(defaultVar -> {
            new URL(url);
            return true;
        }, false);
    }

    public static boolean isValidPathUrl(String path) {
        return TryCore.withReturn(defaultVar -> {
            new File(path).toURI().toURL();
            return true;
        }, false);
    }

    public static Map<String, String> parseQuery(String query) {
        String[] params;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String param : params = query.split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            queryParams.put(key, value);
        }
        return queryParams;
    }

    public static void init(IMediaLoader loader) throws ReInitException {
        if (!FIXERS.isEmpty()) {
            throw new ReInitException(IT.getName());
        }
        WaterMedia.LOGGER.info(IT, "Loading {}'s", (Object)URLFixer.class.getSimpleName());
        FIXERS.addAll(DataTool.toList(ServiceLoader.load(URLFixer.class)));
    }
}

