/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.rendering;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import me.lib720.watermod.reflect.ReflectTool;
import me.srrapero720.watermedia.api.rendering.memory.MemoryAlloc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderAPI {
    public static ByteBuffer createByteBuffer(int size) {
        try {
            return MemoryAlloc.create(size);
        }
        catch (Throwable t) {
            return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        }
    }

    public static ByteBuffer resizeByteBuffer(ByteBuffer buffer, int newSize) {
        try {
            return MemoryAlloc.resize(buffer, newSize);
        }
        catch (Throwable t) {
            throw new NoSuchMethodError("resizeByteBuffer is not available on LWJGL 2.x");
        }
    }

    public static int applyBuffer(BufferedImage image, int width, int height) {
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        boolean alpha = false;
        if (image.getColorModel().hasAlpha()) {
            for (int pixel : pixels) {
                if ((pixel >> 24 & 0xFF) >= 255) continue;
                alpha = true;
                break;
            }
        }
        int bytesPerPixel = alpha ? 4 : 3;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bytesPerPixel));
        for (int pixel : pixels) {
            buffer.put((byte)(pixel >> 16 & 0xFF));
            buffer.put((byte)(pixel >> 8 & 0xFF));
            buffer.put((byte)(pixel & 0xFF));
            if (!alpha) continue;
            buffer.put((byte)(pixel >> 24 & 0xFF));
        }
        ReflectTool.invoke("flip", buffer.getClass(), buffer);
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        if (!alpha) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)(alpha ? 32856 : 32849), (int)width, (int)height, (int)0, (int)(alpha ? 6408 : 6407), (int)5121, (ByteBuffer)buffer);
        return textureID;
    }

    public static void applyBuffer(IntBuffer videoBuffer, int glTexture, int videoWidth, int videoHeight, boolean firstFrame) {
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glBindTexture((int)3553, (int)glTexture);
        if (firstFrame) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)videoWidth, (int)videoHeight, (int)0, (int)6408, (int)5121, (IntBuffer)videoBuffer);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)videoWidth, (int)videoHeight, (int)6408, (int)5121, (IntBuffer)videoBuffer);
        }
    }

    public static void applyBuffer(ByteBuffer videoBuffer, int glTexture, int videoWidth, int videoHeight, boolean firstFrame) {
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glBindTexture((int)3553, (int)glTexture);
        if (firstFrame) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)videoWidth, (int)videoHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)videoBuffer);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)videoWidth, (int)videoHeight, (int)6408, (int)5121, (ByteBuffer)videoBuffer);
        }
    }
}

