/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.player;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import me.lib720.watermod.reflect.ReflectTool;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.player.SyncBasePlayer;
import me.srrapero720.watermedia.api.rendering.RenderAPI;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;

public class SyncVideoPlayer
extends SyncBasePlayer {
    private static final Marker IT = MarkerManager.getMarker((String)"SyncVideoPlayer");
    private volatile int texture;
    private volatile int width = 1;
    private volatile int height = 1;
    private volatile ByteBuffer buffer;
    private volatile Throwable exception;
    protected final Executor playerThreadEx;
    protected final ReentrantLock renderLock = new ReentrantLock();
    protected final AtomicBoolean updateFrame = new AtomicBoolean(false);
    protected final AtomicBoolean updateFirstFrame = new AtomicBoolean(false);
    protected final AtomicBoolean forceFirstFrame = new AtomicBoolean(false);

    @Deprecated
    public SyncVideoPlayer(Executor playerThreadEx) {
        this(null, playerThreadEx, RenderAPI::createByteBuffer);
    }

    @Deprecated
    public SyncVideoPlayer(MediaPlayerFactory factory, Executor playerThreadEx) {
        this(factory, playerThreadEx, RenderAPI::createByteBuffer);
    }

    @Deprecated
    public SyncVideoPlayer(Executor playerThreadEx, BufferHelper bufferHelper) {
        this(null, playerThreadEx, bufferHelper);
    }

    @Deprecated
    public SyncVideoPlayer(MediaPlayerFactory factory, Executor playerThreadEx, BufferHelper bufferHelper) {
        this.playerThreadEx = playerThreadEx;
        this.texture = GL11.glGenTextures();
        this.init(factory, (mediaPlayer, nativeBuffers, bufferFormat) -> {
            this.renderLock.lock();
            try {
                this.buffer = nativeBuffers[0];
                ReflectTool.invoke("rewind", ByteBuffer.class, this.buffer);
                this.updateFrame.set(true);
            }
            catch (Throwable t) {
                if (this.exception == null) {
                    this.exception = t;
                    WaterMedia.LOGGER.fatal(IT, "Failed due process native buffers", t);
                }
            }
            finally {
                this.renderLock.unlock();
            }
        }, (sourceWidth, sourceHeight) -> {
            this.renderLock.lock();
            try {
                this.width = sourceWidth;
                this.height = sourceHeight;
                this.buffer = bufferHelper.create(sourceWidth * sourceHeight * 4);
                this.updateFrame.set(true);
                this.updateFirstFrame.set(true);
            }
            catch (Throwable t) {
                if (this.exception == null) {
                    this.exception = t;
                    WaterMedia.LOGGER.fatal(IT, "Failed due create ByteBuffer", t);
                }
            }
            finally {
                this.renderLock.unlock();
            }
            return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
        });
        if (this.raw() == null) {
            GL11.glDeleteTextures((int)this.texture);
            this.texture = -1;
        }
    }

    @Deprecated
    public void firstFrameMode(boolean forced) {
        this.forceFirstFrame.set(forced);
    }

    public void texSubMode(boolean mode) {
        this.forceFirstFrame.set(mode);
    }

    @Deprecated
    public int prepareTexture() {
        this.preRender();
        return this.texture;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getBufferLock() {
        try {
            this.renderLock.lock();
            ByteBuffer byteBuffer = this.buffer;
            return byteBuffer;
        }
        finally {
            this.renderLock.unlock();
        }
    }

    @Deprecated
    public void preRender() {
        if (this.raw() == null) {
            return;
        }
        this.renderLock.lock();
        try {
            if (this.updateFrame.compareAndSet(true, false)) {
                RenderAPI.applyBuffer(this.buffer, this.texture, this.width, this.height, this.updateFirstFrame.compareAndSet(true, this.forceFirstFrame.get()));
            }
        }
        finally {
            this.renderLock.unlock();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Deprecated
    public int getTexture() {
        return this.texture;
    }

    public int getGlTexture() {
        this.preRender();
        return this.texture;
    }

    public Dimension getDimensions() {
        if (this.raw() == null) {
            return null;
        }
        return new Dimension(this.width, this.height);
    }

    public Dimension getMediaDimensions() {
        if (this.raw() == null) {
            return null;
        }
        return this.raw().mediaPlayer().video().videoDimension();
    }

    @Override
    public void release() {
        this.playerThreadEx.execute(() -> {
            GL11.glDeleteTextures((int)this.texture);
            this.texture = -1;
        });
        super.release();
    }

    @Deprecated
    public static interface BufferHelper {
        @Deprecated
        public ByteBuffer create(int var1);
    }
}

