/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.math;

public class MathAPI {
    public static long tickToMs(int ticks) {
        return (long)ticks * 50L;
    }

    public static long tickToMs(float partialTicks) {
        return (long)(partialTicks * 50.0f);
    }

    public static int msToTick(long ms) {
        return (int)(ms / 50L);
    }

    public static double scaleTempo(long start, long end, long time) {
        if (start < 0L || end < 0L || time < 0L) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        try {
            long duration = end - start;
            long realTime = time - start;
            long result = realTime / duration;
            if (realTime > duration) {
                result %= end - start;
            }
            return result;
        }
        catch (ArithmeticException ignored) {
            return 0.0;
        }
    }

    public static double scaleTempo(double start, double end, double time) {
        if (start < 0.0 || end < 0.0 || time < 0.0) {
            throw new IllegalArgumentException("Invalid negative value");
        }
        try {
            double duration = end - start;
            double realTime = time - start;
            double result = realTime / duration;
            if (realTime > duration) {
                result %= end - start;
            }
            return result;
        }
        catch (ArithmeticException ignored) {
            return 0.0;
        }
    }

    public static double scaleTempoTick(int startTick, int endTick, int timeTick) {
        return MathAPI.scaleTempo(MathAPI.tickToMs(startTick), MathAPI.tickToMs(endTick), MathAPI.tickToMs(timeTick));
    }

    public static long floorMod(long x, long y) {
        try {
            long r = x % y;
            if ((x ^ y) < 0L && r != 0L) {
                return r + y;
            }
            return r;
        }
        catch (ArithmeticException e) {
            return 0L;
        }
    }

    public static int floorMod(int x, int y) {
        try {
            int r = x % y;
            if ((x ^ y) < 0 && r != 0) {
                return r + y;
            }
            return r;
        }
        catch (ArithmeticException e) {
            return 0;
        }
    }

    public static int floorMod(long x, int y) {
        return (int)MathAPI.floorMod(x, (long)y);
    }

    public static int getColorARGB(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double easeIn(double start, double end, double t) {
        return start + (end - start) * t * t;
    }

    public static double easeOut(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.pow(1.0 - t, 2.0));
    }

    public static double easeInOut(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeIn(start, end / 2.0, t * 2.0) : MathAPI.easeOut(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeOutIn(double start, double end, double t) {
        return t < 0.5 ? MathAPI.easeOut(start, end / 2.0, t * 2.0) : MathAPI.easeIn(start + end / 2.0, end, (t - 0.5) * 2.0);
    }

    public static double easeInCircle(double start, double end, double t) {
        return start + (end - start) * (1.0 - Math.sqrt(1.0 - t * t));
    }

    public static double easeOutCircle(double start, double end, double t) {
        return start + (end - start) * Math.sqrt(1.0 - Math.pow(t - 1.0, 2.0));
    }

    public static double easyEase(double start, double end, double t) {
        return start + (end - start) * (t < 0.5 ? 2.0 * t * t : -1.0 + 2.0 * t * (2.0 - t));
    }
}

