/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import me.lib720.madgag.gif.fmsware.GifDecoder;
import me.srrapero720.watermedia.api.rendering.RenderAPI;
import org.lwjgl.opengl.GL11;

public class ImageRenderer {
    public final int width;
    public final int height;
    public final int[] textures;
    public final long[] delay;
    public final long duration;
    public final BufferedImage image;
    public GifDecoder decoder;
    public int remaining;

    @Deprecated
    public ImageRenderer(BufferedImage image) {
        this.image = image;
        if (image == null) {
            throw new NullPointerException();
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.textures = new int[]{-1};
        this.delay = new long[]{0L};
        this.duration = 1L;
        this.decoder = null;
    }

    @Deprecated
    public ImageRenderer(GifDecoder decoder) {
        this.decoder = decoder;
        if (decoder == null) {
            throw new NullPointerException();
        }
        Dimension frameSize = decoder.getFrameSize();
        this.width = (int)frameSize.getWidth();
        this.height = (int)frameSize.getHeight();
        this.textures = new int[decoder.getFrameCount()];
        this.delay = new long[decoder.getFrameCount()];
        this.image = null;
        this.remaining = decoder.getFrameCount();
        long time = 0L;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            this.textures[i] = -1;
            this.delay[i] = time;
            time += (long)decoder.getDelay(i);
        }
        this.duration = time;
    }

    public int texture(long time) {
        if (this.textures == null) {
            return -1;
        }
        if (this.textures.length == 1) {
            return this.texture(0);
        }
        int last = this.texture(0);
        for (int i = 1; i < this.delay.length && this.delay[i] <= time; ++i) {
            last = this.texture(i);
        }
        return last;
    }

    public int texture(int index) {
        if (this.textures[index] == -1) {
            if (this.decoder != null) {
                this.textures[index] = RenderAPI.applyBuffer(this.decoder.getFrame(index), this.width, this.height);
                if (--this.remaining <= 0) {
                    this.decoder = null;
                }
            } else if (this.image != null) {
                this.textures[index] = RenderAPI.applyBuffer(this.image, this.width, this.height);
            }
        }
        return this.textures[index];
    }

    public int texture(int tick, long deltaTime, boolean loop) {
        long time = (long)tick * 50L + deltaTime;
        if (this.duration > 0L && time > this.duration && loop) {
            time %= this.duration;
        }
        return this.texture(time);
    }

    public void flush() {
        if (this.image != null) {
            this.image.flush();
        }
        if (this.decoder != null) {
            for (int i = 0; i < this.decoder.getFrameCount(); ++i) {
                this.decoder.getFrame(i).flush();
            }
            this.decoder = null;
        }
    }

    public void release() {
        for (int i : this.textures) {
            if (i == -1) continue;
            GL11.glDeleteTextures((int)i);
        }
        this.flush();
    }
}

