/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import me.lib720.madgag.gif.fmsware.GifDecoder;
import me.lib720.watermod.concurrent.ThreadCore;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.url.UrlAPI;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.core.CacheCore;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ImageFetch {
    private static final Marker IT = MarkerManager.getMarker((String)"ImageAPI");
    private static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private static final ExecutorService EX = Executors.newScheduledThreadPool(ThreadCore.minThreads(), ThreadCore.factory("WATERMeDIA-if-Worker"));
    private final String url;
    private TaskSuccessful successful;
    private TaskFailed failed;

    public ImageFetch(String url) {
        this.url = url;
    }

    public ImageFetch setOnSuccessCallback(TaskSuccessful task) {
        this.successful = task;
        return this;
    }

    public ImageFetch setOnFailedCallback(TaskFailed task) {
        this.failed = task;
        return this;
    }

    public void start() {
        EX.execute(this::run);
    }

    private void run() {
        block17: {
            try {
                URLFixer.Result result = UrlAPI.fixURL(this.url);
                if (result == null) {
                    throw new IllegalArgumentException("Invalid URL");
                }
                if (result.assumeVideo) {
                    throw new NoPictureException();
                }
                byte[] data = ImageFetch.load(this.url, result.url);
                String type = ImageFetch.readType(data);
                try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
                    if (type != null && type.equalsIgnoreCase("gif")) {
                        GifDecoder gif = new GifDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            if (this.successful != null) {
                                this.successful.run(ImageAPI.renderer(gif));
                            }
                            break block17;
                        }
                        WaterMedia.LOGGER.error(IT, "Failed to read gif: {}", (Object)status);
                        throw new GifDecodingException();
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null && this.successful != null) {
                            this.successful.run(ImageAPI.renderer(image));
                        }
                    }
                    catch (IOException e1) {
                        WaterMedia.LOGGER.error(IT, "Failed to parse BufferedImage from stream", (Throwable)e1);
                        throw e1;
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof NoPictureException)) {
                    WaterMedia.LOGGER.error(IT, "An exception occurred while loading image", (Throwable)e);
                }
                if (this.failed != null) {
                    this.failed.run(e);
                }
                CacheCore.deleteEntry(this.url);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] load(String originalUrl, URL url) throws IOException, NoPictureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String readType(byte[] input) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(input);){
            String string = ImageFetch.readType(in);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        ImageReader reader = null;
        try (ImageInputStream stream = ImageIO.createImageInputStream(input);){
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(stream);
            if (!iterator.hasNext()) {
                String string = null;
                return string;
            }
            reader = iterator.next();
            if (reader.getFormatName().equalsIgnoreCase("gif")) {
                String string = "gif";
                return string;
            }
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(stream, true, true);
            reader.read(0, param);
        }
        catch (IOException e) {
            WaterMedia.LOGGER.error(IT, "Failed to parse input format", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        input.reset();
        if (reader == null) {
            return null;
        }
        return reader.getFormatName();
    }

    private static /* synthetic */ Long lambda$load$2(String lastMod, Long defaultVar) throws Exception {
        return FORMAT.parse(lastMod).getTime();
    }

    private static /* synthetic */ Long lambda$load$1(String expires, Long defaultVar) throws Exception {
        return FORMAT.parse(expires).getTime();
    }

    private static /* synthetic */ Long lambda$load$0(long requestTime, String maxAge, Long defaultVar) throws Exception {
        return requestTime + Long.parseLong(maxAge) * 1000L;
    }

    public static interface TaskSuccessful {
        public void run(ImageRenderer var1);
    }

    public static interface TaskFailed {
        public void run(Exception var1);
    }

    public static final class NoPictureException
    extends Exception {
    }

    public static final class GifDecodingException
    extends Exception {
    }
}

