/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import me.lib720.madgag.gif.fmsware.GifDecoder;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.image.ImageCache;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.loader.IMediaLoader;
import me.srrapero720.watermedia.api.math.MathAPI;
import me.srrapero720.watermedia.core.tools.FileTool;
import me.srrapero720.watermedia.core.tools.JarTool;
import me.srrapero720.watermedia.core.tools.exceptions.ReInitException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ImageAPI {
    public static final Marker IT = MarkerManager.getMarker((String)"API");
    private static final Map<String, ImageRenderer> LOADING_CACHE = new HashMap<String, ImageRenderer>();
    private static ImageRenderer IMG_LOADING;
    private static ImageRenderer IMG_VLC_FAIL;
    private static ImageRenderer IMG_VLC_FAIL_LAND;
    private static ImageRenderer IMG_BLACK;

    public static ImageRenderer failedVLC() {
        return IMG_VLC_FAIL;
    }

    public static ImageRenderer failedVLCLandscape() {
        return IMG_VLC_FAIL_LAND;
    }

    public static ImageRenderer loadingGif() {
        return IMG_LOADING;
    }

    public static ImageRenderer blackPicture() {
        return IMG_BLACK;
    }

    public static ImageRenderer loadingGif(String modId) {
        Path processDir = WaterMedia.getInstance().loader().processPath();
        Path modConfig = processDir.resolve("config/watermedia/assets/" + modId + "/loading.gif");
        if (Files.exists(modConfig, new LinkOption[0])) {
            ImageRenderer renderer = LOADING_CACHE.get(modId);
            if (renderer != null) {
                WaterMedia.LOGGER.warn(IT, "Founded cached reference of '{}' loading gif, consider storing it in a STATIC param", (Object)modId);
                return renderer;
            }
            renderer = ImageAPI.renderer(FileTool.readGif(modConfig.toAbsolutePath()));
            LOADING_CACHE.put(modId, renderer);
            return renderer;
        }
        File modConfigParent = modConfig.getParent().toFile();
        if (!modConfigParent.exists()) {
            WaterMedia.LOGGER.warn(IT, "Custom loading gif not found, creating directories and returning default one");
            if (!modConfigParent.mkdirs()) {
                WaterMedia.LOGGER.error("Cannot create dir '{}'", (Object)modConfigParent.toString());
            }
        } else {
            WaterMedia.LOGGER.error(IT, "Founded directories but custom loading gif is missing");
        }
        return IMG_LOADING;
    }

    public static ImageCache getCache(String originalURL, Executor renderThreadEx) {
        if (originalURL == null || originalURL.isEmpty()) {
            return ImageCache.EMPTY_INSTANCE;
        }
        ImageCache image = ImageCache.CACHE.get(originalURL);
        image = image == null ? new ImageCache(originalURL, renderThreadEx) : image.use();
        ImageCache.CACHE.put(originalURL, image);
        return image;
    }

    public static void reloadCache() {
        for (ImageCache imageCache : ImageCache.CACHE.values()) {
            imageCache.reload();
        }
    }

    public static ImageRenderer renderer(BufferedImage image) {
        return ImageAPI.renderer(image, false);
    }

    public static ImageRenderer renderer(BufferedImage image, boolean absolute) {
        if (absolute) {
            return new ImageRenderer(image);
        }
        return new ImageRenderer(image){

            @Override
            public void flush() {
            }

            @Override
            public void release() {
            }
        };
    }

    public static ImageRenderer renderer(GifDecoder image) {
        return ImageAPI.renderer(image, false);
    }

    public static ImageRenderer renderer(GifDecoder image, boolean absolute) {
        if (!absolute) {
            return new ImageRenderer(image);
        }
        return new ImageRenderer(image){

            @Override
            public void flush() {
            }

            @Override
            public void release() {
            }
        };
    }

    public static void init(IMediaLoader loader) throws ReInitException {
        if (IMG_LOADING != null) {
            throw new ReInitException("ImageAPI");
        }
        WaterMedia.LOGGER.info(IT, "Loading image resources in a {} instance", (Object)ImageRenderer.class.getSimpleName());
        ClassLoader cl = ImageAPI.class.getClassLoader();
        IMG_LOADING = ImageAPI.renderer(FileTool.readGif(loader.processPath().resolve("config/watermedia/assets/loading.gif")), true);
        IMG_VLC_FAIL = ImageAPI.renderer(JarTool.readGif(cl, "/pictures/videolan/failed.gif"), true);
        IMG_VLC_FAIL_LAND = ImageAPI.renderer(JarTool.readGif(cl, "/pictures/videolan/failed-land.gif"), true);
        IMG_BLACK = ImageAPI.renderer(new BufferedImage(1, 1, 2));
        ImageAPI.IMG_BLACK.image.setRGB(0, 0, MathAPI.getColorARGB(255, 0, 0, 0));
    }
}

