/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.watermod.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import me.lib720.watermod.WaterMod;
import me.lib720.watermod.safety.TryCore;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ReflectTool {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");

    public static <T> T getValue(String name, Class<?> clazz, Object instance) {
        return TryCore.withReturn(defaultVar -> {
            Field f = clazz.getField(name);
            f.setAccessible(true);
            return f.get(instance);
        }, null);
    }

    public static void invoke(String name, Class<?> clazz, Object instance) {
        TryCore.simple(() -> {
            Method method = clazz.getMethod(name, new Class[0]);
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
        }, e -> WaterMod.LOGGER.error(IT, "Cannot execute method '{}: {}' caused by '{}' things may not work well", (Object)name, (Object)e.getClass().getSimpleName(), (Object)e.getMessage()));
    }

    public static <T> T invokeWithReturn(String name, Class<?> clazz, Object instance, Object ... args) {
        return TryCore.withReturn(defaultVar -> {
            ArrayList argClazz = new ArrayList();
            for (Object cl : args) {
                argClazz.add(cl.getClass());
            }
            Method method = clazz.getMethod(name, argClazz.toArray(new Class[0]));
            method.setAccessible(true);
            return method.invoke(instance, args);
        }, null);
    }

    public static <T> T findAndInvokeWithReturn(String[] methodNames, Class<?> classFrom, Object instance, Object ... arguments) {
        return TryCore.withReturn(defaultVar -> {
            int i;
            Class[] classes = new Class[arguments.length];
            Object[] classesNames = new String[arguments.length];
            for (i = 0; i < arguments.length; ++i) {
                classes[i] = arguments[i].getClass();
                classesNames[i] = classes[i].getSimpleName();
            }
            for (i = 0; i < methodNames.length; ++i) {
                try {
                    Method method = classFrom.getMethod(methodNames[i], classes);
                    method.setAccessible(true);
                    return method.invoke(instance, arguments);
                }
                catch (NoSuchMethodException e) {
                    WaterMod.LOGGER.error(IT, "Failed to execute '{}.{}({})' caused by {}", (Object)classFrom.getSimpleName(), (Object)methodNames[i], (Object)Arrays.toString(classesNames), (Object)e.getMessage());
                    continue;
                }
            }
            WaterMod.LOGGER.fatal(IT, "Cannot execute any method of '{}: {}', things may not work well", (Object)classFrom.getSimpleName(), (Object)Arrays.toString(methodNames));
            return defaultVar;
        }, null);
    }
}

