/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.watermod.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import me.lib720.watermod.safety.TryCore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadCore {
    private static final Logger LOGGER = LogManager.getLogger((String)"ThreadCore");
    private static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = (t, e) -> LOGGER.error("Failed running {}", (Object)t.getName(), (Object)e);
    private static Thread THREAD_LOGGER = null;
    private static int TWC = 0;

    public static int maxThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int minThreads() {
        int count = ThreadCore.maxThreads();
        if (count <= 2) {
            return 1;
        }
        if (count <= 8) {
            return 2;
        }
        if (count <= 16) {
            return 3;
        }
        if (count <= 32) {
            return 4;
        }
        if (count <= 64) {
            return 6;
        }
        return 8;
    }

    public static void sleep(long timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot sleep thread {}", (Object)Thread.currentThread().getName());
        }
    }

    public static <T> T executeLock(Lock lock, RunnableToReturn<T> runnable) {
        lock.lock();
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static void executeLock(Lock lock, Runnable runnable) {
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    private static Thread thread$basic(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("WATERCoRE-worker-" + ++TWC);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setUncaughtExceptionHandler(EXCEPTION_HANDLER);
        thread.setDaemon(true);
        return thread;
    }

    public static Thread thread(int priority, Runnable runnable) {
        Thread thread = ThreadCore.thread$basic(runnable);
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    public static Thread thread(Runnable runnable) {
        Thread thread = ThreadCore.thread$basic(runnable);
        thread.start();
        return thread;
    }

    public static Thread threadNoDaemon(Runnable runnable) {
        Thread thread = ThreadCore.thread$basic(runnable);
        thread.setDaemon(false);
        thread.start();
        return thread;
    }

    public static Thread threadUncaught(Runnable runnable) {
        Thread thread = ThreadCore.thread$basic(runnable);
        thread.setUncaughtExceptionHandler(null);
        thread.start();
        return thread;
    }

    public static ThreadFactory factory(String name, int priority) {
        AtomicInteger count = new AtomicInteger();
        return r -> {
            Thread t = new Thread(r);
            t.setName(name + "-" + count.incrementAndGet());
            t.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            t.setDaemon(true);
            t.setPriority(priority);
            return t;
        };
    }

    public static ThreadFactory factory(String name) {
        return ThreadCore.factory(name, 3);
    }

    public static void hasClassLoaderOrSet(ClassLoader classLoader) {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static void enableLoggerThreads() {
        ThreadCore.stopLoggerThreads();
        THREAD_LOGGER = ThreadCore.thread(() -> {
            do {
                TryCore.simple(ThreadCore::logThreads);
                ThreadCore.sleep(2000L);
            } while (THREAD_LOGGER != null);
            throw new IllegalStateException("Thread logger was lost");
        });
    }

    public static void stopLoggerThreads() {
        TryCore.simple(() -> {
            if (ThreadCore.isLoggingThreads()) {
                THREAD_LOGGER.interrupt();
            }
            THREAD_LOGGER = null;
            System.gc();
        });
    }

    public static boolean isLoggingThreads() {
        return THREAD_LOGGER != null && !THREAD_LOGGER.isInterrupted();
    }

    public static void logThreads() {
        LOGGER.info("{}\t{}\t{}\t{}\n", (Object)"Name", (Object)"State", (Object)"Priority", (Object)"isDaemon");
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            LOGGER.info("{}\t{}\t{}\t{}\n", (Object)t.getName(), (Object)t.getState(), (Object)t.getPriority(), (Object)t.isDaemon());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simple(TryCore.ActionSimple runnable, TryCore.CatchSimple catchSimple, TryCore.FinallySimple finallySimple) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (catchSimple != null) {
                catchSimple.run(e);
            }
        }
        finally {
            if (finallySimple != null) {
                finallySimple.run();
            }
        }
    }

    public static interface RunnableToReturn<T> {
        public T run();
    }
}

