/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.parser;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import me.lib720.kiulian.downloader.Config;
import me.lib720.kiulian.downloader.YoutubeException;
import me.lib720.kiulian.downloader.cipher.Cipher;
import me.lib720.kiulian.downloader.cipher.CipherFactory;
import me.lib720.kiulian.downloader.downloader.Downloader;
import me.lib720.kiulian.downloader.downloader.YoutubeCallback;
import me.lib720.kiulian.downloader.downloader.request.RequestChannelUploads;
import me.lib720.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import me.lib720.kiulian.downloader.downloader.request.RequestSearchContinuation;
import me.lib720.kiulian.downloader.downloader.request.RequestSearchResult;
import me.lib720.kiulian.downloader.downloader.request.RequestSearchable;
import me.lib720.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import me.lib720.kiulian.downloader.downloader.request.RequestVideoInfo;
import me.lib720.kiulian.downloader.downloader.request.RequestWebpage;
import me.lib720.kiulian.downloader.downloader.response.Response;
import me.lib720.kiulian.downloader.downloader.response.ResponseImpl;
import me.lib720.kiulian.downloader.extractor.Extractor;
import me.lib720.kiulian.downloader.model.playlist.PlaylistDetails;
import me.lib720.kiulian.downloader.model.playlist.PlaylistInfo;
import me.lib720.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import me.lib720.kiulian.downloader.model.search.ContinuatedSearchResult;
import me.lib720.kiulian.downloader.model.search.SearchContinuation;
import me.lib720.kiulian.downloader.model.search.SearchResult;
import me.lib720.kiulian.downloader.model.search.SearchResultChannelDetails;
import me.lib720.kiulian.downloader.model.search.SearchResultElement;
import me.lib720.kiulian.downloader.model.search.SearchResultItem;
import me.lib720.kiulian.downloader.model.search.SearchResultPlaylistDetails;
import me.lib720.kiulian.downloader.model.search.SearchResultShelf;
import me.lib720.kiulian.downloader.model.search.SearchResultVideoDetails;
import me.lib720.kiulian.downloader.model.search.query.QueryAutoCorrection;
import me.lib720.kiulian.downloader.model.search.query.QueryElement;
import me.lib720.kiulian.downloader.model.search.query.QueryElementType;
import me.lib720.kiulian.downloader.model.search.query.QueryRefinementList;
import me.lib720.kiulian.downloader.model.search.query.QuerySuggestion;
import me.lib720.kiulian.downloader.model.subtitles.SubtitlesInfo;
import me.lib720.kiulian.downloader.model.videos.VideoDetails;
import me.lib720.kiulian.downloader.model.videos.VideoInfo;
import me.lib720.kiulian.downloader.model.videos.formats.AudioFormat;
import me.lib720.kiulian.downloader.model.videos.formats.Format;
import me.lib720.kiulian.downloader.model.videos.formats.Itag;
import me.lib720.kiulian.downloader.model.videos.formats.VideoFormat;
import me.lib720.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import me.lib720.kiulian.downloader.parser.Parser;

public class ParserImpl
implements Parser {
    private static final Gson GSON = new Gson();
    private static final String ANDROID_APIKEY = "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
    private final Config config;
    private final Downloader downloader;
    private final Extractor extractor;
    private final CipherFactory cipherFactory;

    public ParserImpl(Config config, Downloader downloader, Extractor extractor, CipherFactory cipherFactory) {
        this.config = config;
        this.downloader = downloader;
        this.extractor = extractor;
        this.cipherFactory = cipherFactory;
    }

    @Override
    public Response<VideoInfo> parseVideo(RequestVideoInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<VideoInfo> result = executorService.submit(() -> this.parseVideo(request.getVideoId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            VideoInfo result = this.parseVideo(request.getVideoId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private VideoInfo parseVideo(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        VideoInfo videoInfo = this.parseVideoAndroid(videoId, callback);
        if (videoInfo == null) {
            videoInfo = this.parseVideoWeb(videoId, callback);
        }
        if (callback != null) {
            callback.onFinished(videoInfo);
        }
        return videoInfo;
    }

    private VideoInfo parseVideoAndroid(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        JsonObject playerResponse;
        String url = "https://youtubei.googleapis.com/youtubei/v1/player?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        String body = "{  \"videoId\": \"" + videoId + "\",  \"context\": {    \"client\": {      \"hl\": \"en\",      \"gl\": \"US\",      \"clientName\": \"ANDROID_TESTSUITE\",      \"clientVersion\": \"1.9\",      \"androidSdkVersion\": 31    }  }}";
        RequestWebpage request = (RequestWebpage)new RequestWebpage(url, "POST", body).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            return null;
        }
        try {
            playerResponse = JsonParser.parseString((String)response.data()).getAsJsonObject();
        }
        catch (Exception ignore) {
            return null;
        }
        VideoDetails videoDetails = this.parseVideoDetails(videoId, playerResponse);
        if (videoDetails.isDownloadable()) {
            List<Format> formats;
            JsonObject context = playerResponse.getAsJsonObject("responseContext");
            String clientVersion = this.extractor.extractClientVersionFromContext(context);
            try {
                formats = this.parseFormats(playerResponse, null, clientVersion);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            List<SubtitlesInfo> subtitlesInfo = this.parseCaptions(playerResponse);
            return new VideoInfo(videoDetails, formats, subtitlesInfo);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoInfo parseVideoWeb(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        JsonObject playerConfig;
        String htmlUrl = "https://www.youtube.com/watch?v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            playerConfig = this.extractor.extractPlayerConfigFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        JsonObject args = playerConfig.getAsJsonObject("args");
        JsonObject playerResponse = args.getAsJsonObject("player_response");
        if (!playerResponse.has("streamingData") && !playerResponse.has("videoDetails")) {
            YoutubeException.BadPageException e = new YoutubeException.BadPageException("streamingData and videoDetails not found");
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        VideoDetails videoDetails = this.parseVideoDetails(videoId, playerResponse);
        if (videoDetails.isDownloadable()) {
            List<Format> formats;
            String jsUrl;
            try {
                jsUrl = this.extractor.extractJsUrlFromConfig(playerConfig, videoId);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            JsonObject context = playerConfig.getAsJsonObject("args").getAsJsonObject("player_response").getAsJsonObject("responseContext");
            String clientVersion = this.extractor.extractClientVersionFromContext(context);
            try {
                formats = this.parseFormats(playerResponse, jsUrl, clientVersion);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            List<SubtitlesInfo> subtitlesInfo = this.parseCaptions(playerResponse);
            return new VideoInfo(videoDetails, formats, subtitlesInfo);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoDetails parseVideoDetails(String videoId, JsonObject playerResponse) {
        if (!playerResponse.has("videoDetails")) {
            return new VideoDetails(videoId);
        }
        JsonObject videoDetails = playerResponse.getAsJsonObject("videoDetails");
        String liveHLSUrl = null;
        JsonPrimitive isLive = videoDetails.getAsJsonPrimitive("isLive");
        if (isLive != null && isLive.getAsBoolean() && playerResponse.has("streamingData")) {
            liveHLSUrl = playerResponse.getAsJsonObject("streamingData").getAsJsonPrimitive("hlsManifestUrl").getAsString();
        }
        return new VideoDetails(videoDetails, liveHLSUrl);
    }

    private List<Format> parseFormats(JsonObject playerResponse, String jsUrl, String clientVersion) throws YoutubeException {
        if (!playerResponse.getAsJsonObject().has("streamingData")) {
            throw new YoutubeException.BadPageException("streamingData not found");
        }
        JsonObject streamingData = playerResponse.getAsJsonObject("streamingData");
        JsonArray jsonFormats = new JsonArray();
        if (streamingData.has("formats")) {
            jsonFormats.addAll(streamingData.getAsJsonArray("formats"));
        }
        JsonArray jsonAdaptiveFormats = new JsonArray();
        if (streamingData.has("adaptiveFormats")) {
            jsonAdaptiveFormats.addAll(streamingData.getAsJsonArray("adaptiveFormats"));
        }
        ArrayList<Format> formats = new ArrayList<Format>(jsonFormats.size() + jsonAdaptiveFormats.size());
        this.populateFormats(formats, jsonFormats, jsUrl, false, clientVersion);
        this.populateFormats(formats, jsonAdaptiveFormats, jsUrl, true, clientVersion);
        return formats;
    }

    private void populateFormats(List<Format> formats, JsonArray jsonFormats, String jsUrl, boolean isAdaptive, String clientVersion) throws YoutubeException.CipherException {
        for (int i = 0; i < jsonFormats.size(); ++i) {
            Itag itag;
            JsonObject json = jsonFormats.get(i).getAsJsonObject();
            JsonPrimitive type = json.getAsJsonPrimitive("type");
            if ("FORMAT_STREAM_TYPE_OTF".equals(type != null ? type.getAsString() : "")) continue;
            int itagValue = json.getAsJsonPrimitive("itag").getAsInt();
            try {
                itag = Itag.valueOf("i" + itagValue);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing format: unknown itag " + itagValue);
                continue;
            }
            try {
                Format format = this.parseFormat(json, jsUrl, itag, isAdaptive, clientVersion);
                formats.add(format);
                continue;
            }
            catch (YoutubeException.CipherException e) {
                throw e;
            }
            catch (YoutubeException e) {
                System.err.println("Error " + e.getMessage() + " parsing format: " + json);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Format parseFormat(JsonObject json, String jsUrl, Itag itag, boolean isAdaptive, String clientVersion) throws YoutubeException {
        boolean hasAudio;
        if (json.has("signatureCipher")) {
            String[] cipherData;
            JsonObject jsonCipher = new JsonObject();
            for (String s : cipherData = json.getAsJsonPrimitive("signatureCipher").getAsString().replace("\\u0026", "&").split("&")) {
                String[] keyValue = s.split("=");
                jsonCipher.addProperty(keyValue[0], keyValue[1]);
            }
            if (!jsonCipher.has("url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            String urlWithSig = jsonCipher.getAsJsonPrimitive("url").getAsString();
            try {
                urlWithSig = URLDecoder.decode(urlWithSig, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (!urlWithSig.contains("signature") && (jsonCipher.has("s") || !urlWithSig.contains("&sig=") && !urlWithSig.contains("&lsig="))) {
                if (jsUrl != null) {
                    String s = jsonCipher.getAsJsonPrimitive("s").getAsString();
                    try {
                        s = URLDecoder.decode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    Cipher cipher = this.cipherFactory.createCipher(jsUrl);
                    String signature = cipher.getSignature(s);
                    String decipheredUrl = urlWithSig + "&sig=" + signature;
                    json.addProperty("url", decipheredUrl);
                } else {
                    throw new YoutubeException.BadPageException("deciphering is required but no js url");
                }
            }
        }
        boolean hasVideo = itag.isVideo() || json.has("size") || json.has("width");
        boolean bl = hasAudio = itag.isAudio() || json.has("audioQuality");
        if (hasVideo && hasAudio) {
            return new VideoWithAudioFormat(json, isAdaptive, clientVersion);
        }
        if (hasVideo) {
            return new VideoFormat(json, isAdaptive, clientVersion);
        }
        return new AudioFormat(json, isAdaptive, clientVersion);
    }

    private List<SubtitlesInfo> parseCaptions(JsonObject playerResponse) {
        if (!playerResponse.has("captions")) {
            return Collections.emptyList();
        }
        JsonObject captions = playerResponse.getAsJsonObject("captions");
        JsonObject playerCaptionsTracklistRenderer = captions.getAsJsonObject("playerCaptionsTracklistRenderer");
        if (playerCaptionsTracklistRenderer == null || playerCaptionsTracklistRenderer.isEmpty()) {
            return Collections.emptyList();
        }
        JsonArray captionsArray = playerCaptionsTracklistRenderer.getAsJsonArray("captionTracks");
        if (captionsArray == null || captionsArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < captionsArray.size(); ++i) {
            JsonObject subtitleInfo = captionsArray.get(i).getAsJsonObject();
            String language = subtitleInfo.getAsJsonPrimitive("languageCode").getAsString();
            String url = subtitleInfo.getAsJsonPrimitive("baseUrl").getAsString();
            String vssId = subtitleInfo.getAsJsonPrimitive("vssId").getAsString();
            if (language == null || url == null || vssId == null) continue;
            boolean isAutoGenerated = vssId.startsWith("a.");
            subtitlesInfo.add(new SubtitlesInfo(url, language, isAutoGenerated, true));
        }
        return subtitlesInfo;
    }

    @Override
    public Response<PlaylistInfo> parsePlaylist(RequestPlaylistInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parsePlaylist(request.getPlaylistId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parsePlaylist(request.getPlaylistId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parsePlaylist(String playlistId, YoutubeCallback<PlaylistInfo> callback) throws YoutubeException {
        List<PlaylistVideoDetails> videos;
        JsonObject initialData;
        String htmlUrl = "https://www.youtube.com/playlist?list=" + playlistId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            initialData = this.extractor.extractInitialDataFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        if (!initialData.has("metadata")) {
            throw new YoutubeException.BadPageException("Invalid initial data json");
        }
        PlaylistDetails playlistDetails = this.parsePlaylistDetails(playlistId, initialData);
        try {
            videos = this.parsePlaylistVideos(initialData, playlistDetails.videoCount());
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return new PlaylistInfo(playlistDetails, videos);
    }

    private PlaylistDetails parsePlaylistDetails(String playlistId, JsonObject initialData) {
        String title = initialData.getAsJsonObject("metadata").getAsJsonObject("playlistMetadataRenderer").getAsJsonPrimitive("title").getAsString();
        JsonArray sideBarItems = initialData.getAsJsonObject("sidebar").getAsJsonObject("playlistSidebarRenderer").getAsJsonArray("items");
        String author = null;
        try {
            author = sideBarItems.get(1).getAsJsonObject().getAsJsonObject("playlistSidebarSecondaryInfoRenderer").getAsJsonObject("videoOwner").getAsJsonObject("videoOwnerRenderer").getAsJsonObject("title").getAsJsonArray("runs").get(0).getAsJsonObject().getAsJsonPrimitive("text").getAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonArray stats = sideBarItems.get(0).getAsJsonObject().getAsJsonObject("playlistSidebarPrimaryInfoRenderer").getAsJsonArray("stats");
        int videoCount = this.extractor.extractIntegerFromText(stats.get(0).getAsJsonObject().getAsJsonArray("runs").get(0).getAsJsonObject().getAsJsonPrimitive("text").getAsString());
        long viewCount = this.extractor.extractLongFromText(stats.get(1).getAsJsonObject().getAsJsonPrimitive("simpleText").getAsString());
        return new PlaylistDetails(playlistId, title, author, videoCount, viewCount);
    }

    private List<PlaylistVideoDetails> parsePlaylistVideos(JsonObject initialData, int videoCount) throws YoutubeException {
        JsonObject content;
        try {
            content = initialData.getAsJsonObject("contents").getAsJsonObject("twoColumnBrowseResultsRenderer").getAsJsonArray("tabs").get(0).getAsJsonObject().getAsJsonObject("tabRenderer").getAsJsonObject("content").getAsJsonObject("sectionListRenderer").getAsJsonArray("contents").get(0).getAsJsonObject().getAsJsonObject("itemSectionRenderer").getAsJsonArray("contents").get(0).getAsJsonObject().getAsJsonObject("playlistVideoListRenderer");
        }
        catch (ClassCastException | NullPointerException e) {
            throw new YoutubeException.BadPageException("Playlist initial data not found");
        }
        AbstractList videos = videoCount > 0 ? new ArrayList(videoCount) : new LinkedList();
        JsonObject context = initialData.getAsJsonObject("responseContext");
        String clientVersion = this.extractor.extractClientVersionFromContext(context);
        this.populatePlaylist(content, videos, clientVersion);
        return videos;
    }

    private void populatePlaylist(JsonObject content, List<PlaylistVideoDetails> videos, String clientVersion) throws YoutubeException {
        JsonArray contents;
        if (content.has("contents")) {
            contents = content.getAsJsonArray("contents");
        } else if (content.has("continuationItems")) {
            contents = content.getAsJsonArray("continuationItems");
        } else {
            if (content.has("continuations")) {
                JsonObject nextContinuationData = content.getAsJsonArray("continuations").get(0).getAsJsonObject().getAsJsonObject("nextContinuationData");
                String continuation = nextContinuationData.getAsJsonPrimitive("continuation").getAsString();
                String ctp = nextContinuationData.getAsJsonPrimitive("clickTrackingParams").getAsString();
                this.loadPlaylistContinuation(continuation, ctp, videos, clientVersion);
                return;
            }
            return;
        }
        for (int i = 0; i < contents.size(); ++i) {
            JsonObject contentsItem = contents.get(i).getAsJsonObject();
            if (contentsItem.has("playlistVideoRenderer")) {
                videos.add(new PlaylistVideoDetails(contentsItem.getAsJsonObject("playlistVideoRenderer")));
                continue;
            }
            if (!contentsItem.has("continuationItemRenderer")) continue;
            JsonObject continuationEndpoint = contentsItem.getAsJsonObject("continuationItemRenderer").getAsJsonObject("continuationEndpoint");
            String continuation = continuationEndpoint.getAsJsonObject("continuationCommand").getAsJsonPrimitive("token").getAsString();
            String ctp = continuationEndpoint.getAsJsonPrimitive("clickTrackingParams").getAsString();
            this.loadPlaylistContinuation(continuation, ctp, videos, clientVersion);
        }
    }

    private void loadPlaylistContinuation(String continuation, String ctp, List<PlaylistVideoDetails> videos, String clientVersion) throws YoutubeException {
        String url = "https://www.youtube.com/youtubei/v1/browse?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        JsonObject context = new JsonObject();
        JsonObject client = new JsonObject();
        client.addProperty("clientName", "WEB");
        client.addProperty("clientVersion", "2.20201021.03.00");
        context.add("client", (JsonElement)client);
        JsonObject clickTracking = new JsonObject();
        clickTracking.addProperty("clickTrackingParams", ctp);
        JsonObject body = new JsonObject();
        body.add("context", (JsonElement)context);
        body.addProperty("continuation", continuation);
        body.add("clickTracking", (JsonElement)clickTracking);
        RequestWebpage request = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(url, "POST", body.toString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", clientVersion)).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
        }
        String html = response.data();
        try {
            JsonObject jsonResponse = JsonParser.parseString((String)html).getAsJsonObject();
            JsonObject content = jsonResponse.has("continuationContents") ? jsonResponse.getAsJsonObject("continuationContents").getAsJsonObject("playlistVideoListContinuation") : jsonResponse.getAsJsonArray("onResponseReceivedActions").get(0).getAsJsonObject().getAsJsonObject("appendContinuationItemsAction");
            this.populatePlaylist(content, videos, clientVersion);
        }
        catch (YoutubeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse playlist continuation json");
        }
    }

    @Override
    public Response<PlaylistInfo> parseChannelsUploads(RequestChannelUploads request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parseChannelsUploads(request.getChannelId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parseChannelsUploads(request.getChannelId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parseChannelsUploads(String channelId, YoutubeCallback<PlaylistInfo> callback) throws YoutubeException {
        String playlistId = null;
        if (channelId.length() == 24 && channelId.startsWith("UC")) {
            playlistId = "UU" + channelId.substring(2);
        } else {
            String channelLink = "https://www.youtube.com/c/" + channelId + "/videos?view=57";
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(channelLink));
            if (!response.ok()) {
                YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", channelLink, response.error().getMessage()));
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            String html = response.data();
            Scanner scan = new Scanner(html);
            scan.useDelimiter("list=");
            while (scan.hasNext()) {
                String pId = scan.next();
                if (!pId.startsWith("UU")) continue;
                playlistId = pId.substring(0, 24);
                break;
            }
        }
        if (playlistId == null) {
            YoutubeException.BadPageException e = new YoutubeException.BadPageException("Upload Playlist not found");
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return this.parsePlaylist(playlistId, callback);
    }

    @Override
    public Response<List<SubtitlesInfo>> parseSubtitlesInfo(RequestSubtitlesInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<List> result = executorService.submit(() -> this.parseSubtitlesInfo(request.getVideoId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            List<SubtitlesInfo> result = this.parseSubtitlesInfo(request.getVideoId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private List<SubtitlesInfo> parseSubtitlesInfo(String videoId, YoutubeCallback<List<SubtitlesInfo>> callback) throws YoutubeException {
        List<String> languages;
        String xmlUrl = "https://video.google.com/timedtext?hl=en&type=list&v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(xmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", xmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String xml = response.data();
        try {
            languages = this.extractor.extractSubtitlesLanguagesFromXml(xml);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (String language : languages) {
            String url = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", language, videoId);
            subtitlesInfo.add(new SubtitlesInfo(url, language, false));
        }
        return subtitlesInfo;
    }

    @Override
    public Response<SearchResult> parseSearchResult(RequestSearchResult request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchResult(request.query(), request.encodeParameters(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchResult(request.query(), request.encodeParameters(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    @Override
    public Response<SearchResult> parseSearchContinuation(RequestSearchContinuation request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchContinuation(request.continuation(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchContinuation(request.continuation(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    @Override
    public Response<SearchResult> parseSearcheable(RequestSearchable request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<SearchResult> result = executorService.submit(() -> this.parseSearchable(request.searchPath(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            SearchResult result = this.parseSearchable(request.searchPath(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private SearchResult parseSearchResult(String query, String parameters, YoutubeCallback<SearchResult> callback) throws YoutubeException {
        String searchQuery;
        try {
            searchQuery = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            searchQuery = query;
            e.printStackTrace();
        }
        String url = "https://www.youtube.com/results?search_query=" + searchQuery;
        if (parameters != null) {
            url = url + "&sp=" + parameters;
        }
        try {
            return this.parseHtmlSearchResult(url);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
    }

    private SearchResult parseSearchable(String searchPath, YoutubeCallback<SearchResult> callback) throws YoutubeException {
        String url = "https://www.youtube.com" + searchPath;
        try {
            return this.parseHtmlSearchResult(url);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
    }

    private SearchResult parseHtmlSearchResult(String url) throws YoutubeException {
        JsonArray rootContents;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(url));
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
        }
        String html = response.data();
        JsonObject initialData = this.extractor.extractInitialDataFromHtml(html);
        try {
            rootContents = initialData.getAsJsonObject("contents").getAsJsonObject("twoColumnSearchResultsRenderer").getAsJsonObject("primaryContents").getAsJsonObject("sectionListRenderer").getAsJsonArray("contents");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Search result root contents not found");
        }
        long estimatedCount = this.extractor.extractLongFromText(initialData.getAsJsonPrimitive("estimatedResults").getAsString());
        String clientVersion = this.extractor.extractClientVersionFromContext(initialData.getAsJsonObject("responseContext"));
        SearchContinuation continuation = this.getSearchContinuation(rootContents, clientVersion);
        return this.parseSearchResult(estimatedCount, rootContents, continuation);
    }

    private SearchResult parseSearchContinuation(SearchContinuation continuation, YoutubeCallback<SearchResult> callback) throws YoutubeException {
        JsonArray rootContents;
        JsonObject jsonResponse;
        String url = "https://www.youtube.com/youtubei/v1/search?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8&prettyPrint=false";
        JsonObject context = new JsonObject();
        JsonObject client = new JsonObject();
        client.addProperty("clientName", "WEB");
        client.addProperty("clientVersion", "2.20201021.03.00");
        context.add("client", (JsonElement)client);
        JsonObject clickTracking = new JsonObject();
        clickTracking.addProperty("clickTrackingParams", continuation.clickTrackingParameters());
        JsonObject body = new JsonObject();
        body.add("context", (JsonElement)context);
        body.addProperty("continuation", continuation.token());
        body.add("clickTracking", (JsonElement)clickTracking);
        RequestWebpage request = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(url, "POST", body.toString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", continuation.clientVersion())).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            jsonResponse = JsonParser.parseString((String)html).getAsJsonObject();
            if (!jsonResponse.has("onResponseReceivedCommands")) {
                throw new YoutubeException.BadPageException("Could not find continuation data");
            }
            rootContents = jsonResponse.getAsJsonArray("onResponseReceivedCommands").get(0).getAsJsonObject().getAsJsonObject("appendContinuationItemsAction").getAsJsonArray("continuationItems");
        }
        catch (YoutubeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse search continuation json");
        }
        long estimatedResults = this.extractor.extractLongFromText(jsonResponse.getAsJsonPrimitive("estimatedResults").getAsString());
        SearchContinuation nextContinuation = this.getSearchContinuation(rootContents, continuation.clientVersion());
        return this.parseSearchResult(estimatedResults, rootContents, nextContinuation);
    }

    private SearchContinuation getSearchContinuation(JsonArray rootContents, String clientVersion) {
        if (rootContents.size() > 1 && rootContents.get(1).getAsJsonObject().has("continuationItemRenderer")) {
            JsonObject endPoint = rootContents.get(1).getAsJsonObject().getAsJsonObject("continuationItemRenderer").getAsJsonObject("continuationEndpoint");
            String token = endPoint.getAsJsonObject("continuationCommand").getAsJsonPrimitive("token").getAsString();
            String ctp = endPoint.getAsJsonPrimitive("clickTrackingParams").getAsString();
            return new SearchContinuation(token, clientVersion, ctp);
        }
        return null;
    }

    private SearchResult parseSearchResult(long estimatedResults, JsonArray rootContents, SearchContinuation continuation) throws YoutubeException.BadPageException {
        JsonArray contents;
        try {
            contents = rootContents.get(0).getAsJsonObject().getAsJsonObject("itemSectionRenderer").getAsJsonArray("contents");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Search result contents not found");
        }
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>(contents.size());
        HashMap<QueryElementType, QueryElement> queryElements = new HashMap<QueryElementType, QueryElement>();
        for (int i = 0; i < contents.size(); ++i) {
            SearchResultElement element = ParserImpl.parseSearchResultElement(contents.get(i).getAsJsonObject());
            if (element == null) continue;
            if (element instanceof SearchResultItem) {
                items.add((SearchResultItem)element);
                continue;
            }
            QueryElement queryElement = (QueryElement)element;
            queryElements.put(queryElement.type(), queryElement);
        }
        if (continuation == null) {
            return new SearchResult(estimatedResults, items, queryElements);
        }
        return new ContinuatedSearchResult(estimatedResults, items, queryElements, continuation);
    }

    private static SearchResultElement parseSearchResultElement(JsonObject jsonItem) {
        String rendererKey = (String)jsonItem.keySet().iterator().next();
        JsonObject jsonRenderer = jsonItem.getAsJsonObject(rendererKey);
        switch (rendererKey) {
            case "videoRenderer": {
                return new SearchResultVideoDetails(jsonRenderer, false);
            }
            case "movieRenderer": {
                return new SearchResultVideoDetails(jsonRenderer, true);
            }
            case "playlistRenderer": {
                return new SearchResultPlaylistDetails(jsonRenderer);
            }
            case "channelRenderer": {
                return new SearchResultChannelDetails(jsonRenderer);
            }
            case "shelfRenderer": {
                return new SearchResultShelf(jsonRenderer);
            }
            case "showingResultsForRenderer": {
                return new QueryAutoCorrection(jsonRenderer);
            }
            case "didYouMeanRenderer": {
                return new QuerySuggestion(jsonRenderer);
            }
            case "horizontalCardListRenderer": {
                return new QueryRefinementList(jsonRenderer);
            }
        }
        System.out.println("Unknown search result element type " + rendererKey);
        System.out.println(jsonItem);
        return null;
    }
}

