/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.videos.formats;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import me.lib720.kiulian.downloader.model.videos.formats.VideoFormat;
import me.lib720.kiulian.downloader.model.videos.quality.AudioQuality;

public class VideoWithAudioFormat
extends VideoFormat {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public VideoWithAudioFormat(JsonObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        JsonPrimitive audioSampleRateJson = json.getAsJsonPrimitive("audioSampleRate");
        JsonPrimitive averageBitrateJson = json.getAsJsonPrimitive("averageBitrate");
        this.audioSampleRate = audioSampleRateJson != null ? audioSampleRateJson.getAsInt() : 0;
        this.averageBitrate = averageBitrateJson != null ? averageBitrateJson.getAsInt() : 0;
        AudioQuality audioQuality = null;
        if (json.has("audioQuality")) {
            String[] split = json.getAsJsonPrimitive("audioQuality").getAsString().split("_");
            String quality = split[split.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(quality);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio/video";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

