/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.videos.formats;

import com.google.gson.JsonObject;
import me.lib720.kiulian.downloader.model.videos.formats.Format;
import me.lib720.kiulian.downloader.model.videos.quality.VideoQuality;

public class VideoFormat
extends Format {
    private final int fps;
    private final String qualityLabel;
    private final Integer width;
    private final Integer height;
    private final VideoQuality videoQuality;

    public VideoFormat(JsonObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        this.fps = json.getAsJsonPrimitive("fps").getAsInt();
        this.qualityLabel = json.getAsJsonPrimitive("qualityLabel").getAsString();
        if (json.has("size")) {
            String[] split = json.getAsJsonPrimitive("size").getAsString().split("x");
            this.width = Integer.parseInt(split[0]);
            this.height = Integer.parseInt(split[1]);
        } else {
            this.width = json.getAsJsonPrimitive("width").getAsInt();
            this.height = json.getAsJsonPrimitive("height").getAsInt();
        }
        VideoQuality videoQuality = null;
        if (json.has("quality")) {
            try {
                videoQuality = VideoQuality.valueOf(json.getAsJsonPrimitive("quality").getAsString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.videoQuality = videoQuality;
    }

    @Override
    public String type() {
        return "video";
    }

    public int fps() {
        return this.fps;
    }

    public VideoQuality videoQuality() {
        return this.videoQuality != null ? this.videoQuality : this.itag.videoQuality();
    }

    public String qualityLabel() {
        return this.qualityLabel;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }
}

