/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.videos.formats;

import com.google.gson.JsonObject;
import me.lib720.kiulian.downloader.model.videos.formats.Format;
import me.lib720.kiulian.downloader.model.videos.quality.AudioQuality;

public class AudioFormat
extends Format {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public AudioFormat(JsonObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        this.audioSampleRate = json.getAsJsonPrimitive("audioSampleRate").getAsInt();
        this.averageBitrate = json.getAsJsonPrimitive("averageBitrate").getAsInt();
        AudioQuality audioQuality = null;
        if (json.has("audioQuality")) {
            String[] split = json.getAsJsonPrimitive("audioQuality").getAsString().split("_");
            String quality = split[split.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(quality);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

