/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.videos;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import me.lib720.kiulian.downloader.model.AbstractVideoDetails;

public class VideoDetails
extends AbstractVideoDetails {
    private List<String> keywords;
    private String shortDescription;
    private long viewCount;
    private int averageRating;
    private boolean isLiveContent;
    private String liveUrl;

    public VideoDetails(String videoId) {
        this.videoId = videoId;
    }

    public VideoDetails(JsonObject json, String liveHLSUrl) {
        super(json);
        this.title = json.getAsJsonPrimitive("title").getAsString();
        this.author = json.getAsJsonPrimitive("author").getAsString();
        JsonPrimitive isLivePrimitive = json.getAsJsonPrimitive("isLive");
        this.isLive = isLivePrimitive != null && isLivePrimitive.getAsBoolean();
        this.keywords = new ArrayList<String>();
        List keywordsJson = json.has("keywords") ? json.getAsJsonArray("keywords").asList() : new ArrayList();
        for (JsonElement e : keywordsJson) {
            this.keywords.add(e.getAsString());
        }
        this.shortDescription = json.getAsJsonPrimitive("shortDescription").getAsString();
        JsonPrimitive avgRating = json.getAsJsonPrimitive("averageRating");
        this.averageRating = avgRating != null ? avgRating.getAsInt() : 0;
        this.viewCount = json.getAsJsonPrimitive("viewCount").getAsLong();
        this.isLiveContent = json.getAsJsonPrimitive("isLiveContent").getAsBoolean();
        this.liveUrl = liveHLSUrl;
    }

    @Override
    public boolean isDownloadable() {
        return !this.isLive() && (!this.isLiveContent || this.lengthSeconds() != 0);
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public String description() {
        return this.shortDescription;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public int averageRating() {
        return this.averageRating;
    }

    public boolean isLiveContent() {
        return this.isLiveContent;
    }

    public String liveUrl() {
        return this.liveUrl;
    }
}

