/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.search;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.lib720.kiulian.downloader.model.AbstractListVideoDetails;
import me.lib720.kiulian.downloader.model.Utils;
import me.lib720.kiulian.downloader.model.search.SearchResultItem;
import me.lib720.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultVideoDetails
extends AbstractListVideoDetails
implements SearchResultItem {
    private final boolean isMovie;
    private String description;
    private String viewCountText;
    private long viewCount;
    private long startTime;
    private List<String> badges;
    private List<String> richThumbnails;

    public SearchResultVideoDetails(JsonObject json, boolean isMovie) {
        super(json);
        int i;
        this.isMovie = isMovie;
        if (json.has("lengthText")) {
            String lengthText = json.getAsJsonObject("lengthText").getAsJsonPrimitive("simpleText").getAsString();
            this.lengthSeconds = Utils.parseLengthSeconds(lengthText);
        }
        if (isMovie) {
            this.description = Utils.parseRuns(json.getAsJsonObject("descriptionSnippet"));
        } else if (json.has("detailedMetadataSnippets")) {
            this.description = Utils.parseRuns(json.getAsJsonArray("detailedMetadataSnippets").get(0).getAsJsonObject().getAsJsonObject("snippetText"));
        }
        if (json.has("upcomingEventData")) {
            String startTimeText = json.getAsJsonObject("upcomingEventData").getAsJsonPrimitive("startTime").getAsString();
            this.startTime = Long.parseLong(startTimeText);
            this.viewCount = -1L;
        } else if (json.has("viewCountText")) {
            JsonObject jsonCount = json.getAsJsonObject("viewCountText");
            if (jsonCount.has("simpleText")) {
                this.viewCountText = jsonCount.getAsJsonPrimitive("simpleText").getAsString();
                this.viewCount = Utils.parseViewCount(this.viewCountText);
            } else if (jsonCount.has("runs")) {
                this.viewCountText = Utils.parseRuns(jsonCount);
                this.viewCount = -1L;
            }
        }
        if (json.has("badges")) {
            JsonArray jsonBadges = json.getAsJsonArray("badges");
            this.badges = new ArrayList<String>(jsonBadges.size());
            for (i = 0; i < jsonBadges.size(); ++i) {
                JsonObject jsonBadge = jsonBadges.get(i).getAsJsonObject();
                if (!jsonBadge.has("metadataBadgeRenderer")) continue;
                this.badges.add(jsonBadge.getAsJsonObject("metadataBadgeRenderer").getAsJsonPrimitive("label").getAsString());
            }
        }
        if (json.has("richThumbnail")) {
            try {
                JsonArray jsonThumbs = json.getAsJsonObject("richThumbnail").getAsJsonObject("movingThumbnailRenderer").getAsJsonObject("movingThumbnailDetails").getAsJsonArray("thumbnails");
                this.richThumbnails = new ArrayList<String>(jsonThumbs.size());
                for (i = 0; i < jsonThumbs.size(); ++i) {
                    this.richThumbnails.add(jsonThumbs.get(i).getAsJsonObject().getAsJsonPrimitive("url").getAsString());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.VIDEO;
    }

    @Override
    public SearchResultVideoDetails asVideo() {
        return this;
    }

    public boolean isMovie() {
        return this.isMovie;
    }

    @Override
    public boolean isLive() {
        return this.viewCount == -1L;
    }

    public String viewCountText() {
        return this.viewCountText;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public long startTime() {
        return this.startTime;
    }

    public List<String> badges() {
        return this.badges;
    }

    public List<String> richThumbnails() {
        return this.richThumbnails;
    }

    public String description() {
        return this.description;
    }
}

