/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.search;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.lib720.kiulian.downloader.model.search.SearchResultItem;
import me.lib720.kiulian.downloader.model.search.SearchResultItemType;
import me.lib720.kiulian.downloader.model.search.SearchResultVideoDetails;

public class SearchResultShelf
implements SearchResultItem {
    private final String title;
    private final List<SearchResultVideoDetails> videos;

    public SearchResultShelf(JsonObject json) {
        this.title = json.getAsJsonObject("title").getAsJsonPrimitive("simpleText").getAsString();
        JsonObject jsonContent = json.getAsJsonObject("content");
        String contentRendererKey = (String)jsonContent.keySet().iterator().next();
        boolean isMovieShelf = contentRendererKey.contains("Movie");
        JsonArray jsonItems = jsonContent.getAsJsonObject(contentRendererKey).getAsJsonArray("items");
        this.videos = new ArrayList<SearchResultVideoDetails>(jsonItems.size());
        for (int i = 0; i < jsonItems.size(); ++i) {
            JsonObject jsonItem = jsonItems.get(i).getAsJsonObject();
            String itemRendererKey = (String)jsonItem.keySet().iterator().next();
            this.videos.add(new SearchResultVideoDetails(jsonItem.getAsJsonObject(itemRendererKey), isMovieShelf));
        }
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.SHELF;
    }

    @Override
    public SearchResultShelf asShelf() {
        return this;
    }

    @Override
    public String title() {
        return this.title;
    }

    public List<SearchResultVideoDetails> videos() {
        return this.videos;
    }
}

