/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.search;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import me.lib720.kiulian.downloader.model.Utils;
import me.lib720.kiulian.downloader.model.search.AbstractSearchResultList;
import me.lib720.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultPlaylistDetails
extends AbstractSearchResultList {
    private final String playlistId;
    private final int videoCount;

    public SearchResultPlaylistDetails(JsonObject json) {
        super(json);
        this.playlistId = json.getAsJsonPrimitive("playlistId").getAsString();
        JsonArray thumbnailGroups = json.getAsJsonArray("thumbnails");
        this.thumbnails = new LinkedList();
        for (int i = 0; i < thumbnailGroups.size(); ++i) {
            this.thumbnails.addAll(Utils.parseThumbnails(thumbnailGroups.get(i).getAsJsonObject()));
        }
        this.videoCount = json.has("videoCount") ? Integer.parseInt(json.getAsJsonPrimitive("videoCount").getAsString()) : -1;
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.PLAYLIST;
    }

    @Override
    public SearchResultPlaylistDetails asPlaylist() {
        return this;
    }

    public String playlistId() {
        return this.playlistId;
    }

    public int videoCount() {
        return this.videoCount;
    }
}

