/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.kiulian.downloader.model.search;

import com.google.gson.JsonObject;
import me.lib720.kiulian.downloader.model.Utils;
import me.lib720.kiulian.downloader.model.search.AbstractSearchResultList;
import me.lib720.kiulian.downloader.model.search.SearchResultItemType;

public class SearchResultChannelDetails
extends AbstractSearchResultList {
    private final String channelId;
    private final String videoCountText;
    private final String subscriberCountText;
    private final String description;

    public SearchResultChannelDetails(JsonObject json) {
        super(json);
        this.channelId = json.getAsJsonPrimitive("channelId").getAsString();
        this.videoCountText = Utils.parseRuns(json.getAsJsonObject("videoCountText"));
        this.subscriberCountText = json.has("subscriberCountText") ? json.getAsJsonObject("subscriberCountText").getAsJsonPrimitive("simpleText").getAsString() : null;
        this.description = Utils.parseRuns(json.getAsJsonObject("descriptionSnippet"));
        this.thumbnails = Utils.parseThumbnails(json.getAsJsonObject("thumbnail"));
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.CHANNEL;
    }

    @Override
    public SearchResultChannelDetails asChannel() {
        return this;
    }

    public String channelId() {
        return this.channelId;
    }

    public String videoCountText() {
        return this.videoCountText;
    }

    public String subscriberCountText() {
        return this.subscriberCountText;
    }

    public String description() {
        return this.description;
    }
}

