/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.support;

import java.util.Properties;
import me.lib720.caprica.vlcj.support.version.Version;

public final class Info {
    private Version vlcjVersion = this.getVlcjVersion();
    private final String os = String.format("%s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    private final String javaVersion = String.format("%s %s", System.getProperty("java.version"), System.getProperty("java.vendor"));
    private final String javaHome = System.getProperty("java.home");
    private final String jnaLibraryPath = System.getProperty("jna.library.path");
    private final String javaLibraryPath = System.getProperty("java.library.path");
    private final String path = System.getenv("PATH");
    private final String pluginPath = System.getenv("VLC_PLUGIN_PATH");
    private final String ldLibraryPath = System.getenv("LD_LIBRARY_PATH");
    private final String dyldLibraryPath = System.getenv("DYLD_LIBRARY_PATH");
    private final String dyldFallbackLibraryPath = System.getenv("DYLD_FALLBACK_LIBRARY_PATH");

    public static Info getInstance() {
        return InfoHolder.INSTANCE;
    }

    private Info() {
    }

    public Version vlcjVersion() {
        return this.vlcjVersion;
    }

    public String os() {
        return this.os;
    }

    public String javaVersion() {
        return this.javaVersion;
    }

    public String javaHome() {
        return this.javaHome;
    }

    public String jnaLibraryPath() {
        return this.jnaLibraryPath;
    }

    public String javaLibraryPath() {
        return this.javaLibraryPath;
    }

    public String path() {
        return this.path;
    }

    public String pluginPath() {
        return this.pluginPath;
    }

    public String ldLibraryPath() {
        return this.ldLibraryPath;
    }

    public String dyldLibraryPath() {
        return this.dyldLibraryPath;
    }

    public String dyldFallbackLibraryPath() {
        return this.dyldFallbackLibraryPath;
    }

    private Version getVlcjVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/me/lib720/caprica/vlcj/build.properties"));
            return new Version(properties.getProperty("build.version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return new StringBuilder(200).append(this.getClass().getSimpleName()).append('[').append("vlcjVersion=").append(this.vlcjVersion).append(',').append("os=").append(this.os).append(',').append("javaVersion=").append(this.javaVersion).append(',').append("javaHome=").append(this.javaHome).append(',').append("jnaLibraryPath=").append(this.jnaLibraryPath).append(',').append("javaLibraryPath=").append(this.javaLibraryPath).append(',').append("path=").append(this.path).append(',').append("pluginPath=").append(this.pluginPath).append(',').append("ldLibraryPath=").append(this.ldLibraryPath).append(',').append("dyldLibraryPath=").append(this.dyldLibraryPath).append(',').append("dyldFallbackLibraryPath=").append(this.dyldFallbackLibraryPath).append(']').toString();
    }

    private static class InfoHolder {
        public static final Info INSTANCE = new Info();

        private InfoHolder() {
        }
    }
}

