/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import me.lib720.caprica.vlcj.binding.LibVlc;
import me.lib720.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import me.lib720.caprica.vlcj.player.base.BaseApi;
import me.lib720.caprica.vlcj.player.base.Logo;
import me.lib720.caprica.vlcj.player.base.LogoPosition;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;

public final class LogoApi
extends BaseApi {
    LogoApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void enable(boolean enable) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    public void setDuration(int duration) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_delay.intValue(), duration);
    }

    public void setOpacity(int opacity) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    public void setOpacity(float opacity) {
        int opacityValue = Math.round(opacity * 255.0f);
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacityValue);
    }

    public void setLocation(int x, int y) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    public void setPosition(LogoPosition position) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), position.intValue());
    }

    public void setRepeat(int repeat) {
        LibVlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_repeat.intValue(), repeat);
    }

    public void setFile(String logoFile) {
        LibVlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    public void setImage(RenderedImage logoImage) {
        File file = null;
        try {
            file = File.createTempFile("vlcj-logo-", ".png");
            ImageIO.write(logoImage, "png", file);
            if (file.exists()) {
                this.setFile(file.getAbsolutePath());
                file.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set logo image", e);
        }
    }

    public void set(Logo logo) {
        logo.apply(this.mediaPlayer);
    }
}

