/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.base;

import me.lib720.caprica.vlcj.binding.LibVlc;
import me.lib720.caprica.vlcj.player.base.BaseApi;
import me.lib720.caprica.vlcj.player.base.MediaPlayer;
import me.lib720.caprica.vlcj.player.base.MediaPlayerLatch;

public final class ControlsApi
extends BaseApi {
    private boolean repeat;

    ControlsApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public void play() {
        this.mediaPlayer.onBeforePlay();
        LibVlc.libvlc_media_player_play(this.mediaPlayerInstance);
    }

    public boolean start() {
        return new MediaPlayerLatch(this.mediaPlayer).play();
    }

    public void stop() {
        LibVlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    public void setPause(boolean pause) {
        LibVlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, pause ? 1 : 0);
    }

    public void pause() {
        LibVlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    public void nextFrame() {
        LibVlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    public void skipTime(long delta) {
        long current = this.mediaPlayer.status().time();
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    public void skipPosition(float delta) {
        float current = this.mediaPlayer.status().position();
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    public void setTime(long time) {
        LibVlc.libvlc_media_player_set_time(this.mediaPlayerInstance, Math.max(time, 0L));
    }

    public void setPosition(float position) {
        LibVlc.libvlc_media_player_set_position(this.mediaPlayerInstance, Math.max(position, 0.0f));
    }

    public boolean setRate(float rate) {
        return LibVlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate) != -1;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean getRepeat() {
        return this.repeat;
    }
}

