/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.media;

import java.util.List;
import me.lib720.caprica.vlcj.binding.LibVlc;
import me.lib720.caprica.vlcj.binding.NativeString;
import me.lib720.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import me.lib720.caprica.vlcj.media.AudioTrackInfo;
import me.lib720.caprica.vlcj.media.BaseApi;
import me.lib720.caprica.vlcj.media.Media;
import me.lib720.caprica.vlcj.media.MediaStatistics;
import me.lib720.caprica.vlcj.media.MediaType;
import me.lib720.caprica.vlcj.media.TextTrackInfo;
import me.lib720.caprica.vlcj.media.TrackInfo;
import me.lib720.caprica.vlcj.media.TrackInformation;
import me.lib720.caprica.vlcj.media.TrackType;
import me.lib720.caprica.vlcj.media.VideoTrackInfo;
import me.lib720.caprica.vlcj.player.base.State;

public final class InfoApi
extends BaseApi {
    private final libvlc_media_stats_t statsInstance = new libvlc_media_stats_t();

    InfoApi(Media media) {
        super(media);
    }

    public String mrl() {
        return NativeString.copyAndFreeNativeString(LibVlc.libvlc_media_get_mrl(this.mediaInstance));
    }

    public MediaType type() {
        return MediaType.mediaType(LibVlc.libvlc_media_get_type(this.mediaInstance));
    }

    public State state() {
        return State.state(LibVlc.libvlc_media_get_state(this.mediaInstance));
    }

    public long duration() {
        return LibVlc.libvlc_media_get_duration(this.mediaInstance);
    }

    public List<? extends TrackInfo> tracks(TrackType ... types) {
        return TrackInformation.getTrackInfo(this.mediaInstance, types);
    }

    public List<AudioTrackInfo> audioTracks() {
        return this.tracks(TrackType.AUDIO);
    }

    public List<VideoTrackInfo> videoTracks() {
        return this.tracks(TrackType.VIDEO);
    }

    public List<TextTrackInfo> textTracks() {
        return this.tracks(TrackType.TEXT);
    }

    public boolean statistics(MediaStatistics mediaStatistics) {
        if (LibVlc.libvlc_media_get_stats(this.mediaInstance, this.statsInstance) != 0) {
            mediaStatistics.apply(this.statsInstance);
            return true;
        }
        return false;
    }

    public MediaStatistics statistics() {
        if (LibVlc.libvlc_media_get_stats(this.mediaInstance, this.statsInstance) != 0) {
            MediaStatistics mediaStatistics = new MediaStatistics();
            mediaStatistics.apply(this.statsInstance);
            return mediaStatistics;
        }
        return null;
    }
}

