/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory.discovery.strategy;

import me.lib720.caprica.vlcj.binding.LibC;
import me.lib720.caprica.vlcj.binding.RuntimeUtil;
import me.lib720.caprica.vlcj.factory.discovery.provider.DirectoryProviderDiscoveryStrategy;

public class WindowsNativeDiscoveryStrategy
extends DirectoryProviderDiscoveryStrategy {
    private static final String[] FILENAME_PATTERNS = new String[]{"libvlc\\.dll", "libvlccore\\.dll"};
    private static final String[] PLUGIN_PATH_FORMATS = new String[]{"%s\\plugins", "%s\\vlc\\plugins"};

    public WindowsNativeDiscoveryStrategy() {
        super(FILENAME_PATTERNS, PLUGIN_PATH_FORMATS);
    }

    @Override
    public boolean supported() {
        return RuntimeUtil.isWindows();
    }

    @Override
    protected boolean setPluginPath(String pluginPath) {
        return LibC.INSTANCE._putenv(String.format("%s=%s", "VLC_PLUGIN_PATH", pluginPath)) == 0;
    }
}

