/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory.discovery.provider;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import me.lib720.caprica.vlcj.binding.RuntimeUtil;
import me.lib720.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;

public class WindowsInstallDirectoryProvider
implements DiscoveryDirectoryProvider {
    private static final String VLC_REGISTRY_KEY = "SOFTWARE\\VideoLAN\\VLC";
    private static final String VLC_INSTALL_DIR_KEY = "InstallDir";

    @Override
    public int priority() {
        return -3;
    }

    @Override
    public String[] directories() {
        String[] stringArray;
        String installDir = this.getVlcInstallDir();
        if (installDir != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = installDir;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public boolean supported() {
        return RuntimeUtil.isWindows();
    }

    private String getVlcInstallDir() {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)VLC_REGISTRY_KEY, (String)VLC_INSTALL_DIR_KEY);
        }
        catch (Exception e) {
            return null;
        }
    }
}

