/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.factory.discovery.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import me.lib720.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;
import me.lib720.caprica.vlcj.factory.discovery.strategy.BaseNativeDiscoveryStrategy;

public abstract class DirectoryProviderDiscoveryStrategy
extends BaseNativeDiscoveryStrategy {
    private final ServiceLoader<DiscoveryDirectoryProvider> directoryProviders = ServiceLoader.load(DiscoveryDirectoryProvider.class);

    public DirectoryProviderDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        super(filenamePatterns, pluginPathFormats);
    }

    @Override
    public final List<String> discoveryDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        for (DiscoveryDirectoryProvider provider : this.getSupportedProviders()) {
            directories.addAll(Arrays.asList(provider.directories()));
        }
        return directories;
    }

    private List<DiscoveryDirectoryProvider> getSupportedProviders() {
        ArrayList<DiscoveryDirectoryProvider> result = new ArrayList<DiscoveryDirectoryProvider>();
        for (DiscoveryDirectoryProvider service : this.directoryProviders) {
            if (!service.supported()) continue;
            result.add(service);
        }
        return this.sort(result);
    }

    private List<DiscoveryDirectoryProvider> sort(List<DiscoveryDirectoryProvider> providers) {
        providers.sort((p1, p2) -> p2.priority() - p1.priority());
        return providers;
    }
}

