/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.Config;
import tschipp.fakename.FakeNamePacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="fakename")
public class FakeName {
    public static final String MODID = "fakename";
    public static SimpleChannel network;
    public static IModInfo info;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    private static final RegistryObject<SingletonArgumentInfo<CommandFakeName.FakenameArgumentType>> FAKENAME_ARGUMENT;

    public FakeName() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        info = ModLoadingContext.get().getActiveContainer().getModInfo();
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "fakenamechannel"), () -> info.getVersion().toString(), s -> true, s -> true);
            network.registerMessage(0, FakeNamePacket.class, FakeNamePacket::toBytes, FakeNamePacket::new, FakeNamePacket::handle);
        });
    }

    public static void sendPacket(Player player, String fakename, int operation) {
        FakeName.performFakenameOperation(player, fakename, operation);
        network.send(PacketDistributor.ALL.noArg(), (Object)new FakeNamePacket(fakename, player.m_19879_(), operation));
    }

    public static void performFakenameOperation(Player player, String fakename, int operation) {
        CompoundTag tag = player.getPersistentData();
        if (operation == 0) {
            tag.m_128359_(MODID, fakename);
            player.refreshDisplayName();
        } else {
            tag.m_128473_(MODID);
            player.refreshDisplayName();
        }
    }

    static {
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)MODID);
        FAKENAME_ARGUMENT = COMMAND_ARGUMENT_TYPES.register(MODID, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(CommandFakeName.FakenameArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(CommandFakeName.FakenameArgumentType::fakename)));
    }
}

