/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import tschipp.fakename.Config;
import tschipp.fakename.FakeName;

public class CommandFakeName {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fakename").then(Commands.m_82127_((String)"real").then(Commands.m_82129_((String)"fakename", (ArgumentType)FakenameArgumentType.fakename()).executes(cmd -> CommandFakeName.handleRealname((CommandSourceStack)cmd.getSource(), (String)cmd.getArgument("fakename", String.class)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(src -> {
            boolean b = src.m_6761_(((Integer)Config.SERVER.commandPermissionLevelAll.get()).intValue());
            return b;
        })).executes(cmd -> CommandFakeName.handleClear((CommandSourceStack)cmd.getSource(), EntityArgument.m_91477_((CommandContext)cmd, (String)"target"))))).executes(cmd -> CommandFakeName.handleClear((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"fakename", (ArgumentType)StringArgumentType.string()).executes(cmd -> CommandFakeName.handleSetname((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()), StringArgumentType.getString((CommandContext)cmd, (String)"fakename"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).requires(src -> src.m_6761_(((Integer)Config.SERVER.commandPermissionLevelAll.get()).intValue()))).then(Commands.m_82129_((String)"fakename", (ArgumentType)StringArgumentType.string()).executes(cmd -> CommandFakeName.handleSetname((CommandSourceStack)cmd.getSource(), EntityArgument.m_91477_((CommandContext)cmd, (String)"target"), StringArgumentType.getString((CommandContext)cmd, (String)"fakename"))))));
        dispatcher.register(builder);
    }

    private static int handleSetname(CommandSourceStack source, Collection<ServerPlayer> players, String string) {
        string = ((String)string).replace("&", "\u00a7") + "\u00a7r";
        for (ServerPlayer player : players) {
            CompoundTag tag = player.getPersistentData();
            tag.m_128359_("fakename", (String)string);
            source.m_243053_((Component)Component.m_237113_((String)(player.m_7755_().getString() + "'s name is now " + (String)string)));
            FakeName.sendPacket((Player)player, (String)string, 0);
        }
        return 1;
    }

    private static int handleClear(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            CompoundTag tag = player.getPersistentData();
            tag.m_128473_("fakename");
            source.m_243053_((Component)Component.m_237113_((String)(player.m_7755_().getString() + "'s fake name was cleared!")));
            FakeName.sendPacket((Player)player, "", 1);
        }
        return 1;
    }

    private static int handleRealname(CommandSourceStack source, String string) {
        String copy = string;
        string = ((String)string).replace("&", "\u00a7") + "\u00a7r";
        string = ChatFormatting.m_126649_((String)string);
        PlayerList players = source.m_81377_().m_6846_();
        boolean succ = false;
        for (Player player : players.m_11314_()) {
            String fn;
            if (player.getPersistentData() == null || !player.getPersistentData().m_128441_("fakename") || !(fn = ChatFormatting.m_126649_((String)player.getPersistentData().m_128461_("fakename"))).equalsIgnoreCase((String)string)) continue;
            source.m_243053_((Component)Component.m_237113_((String)(copy + "'s real name is " + player.m_36316_().getName())));
            succ = true;
        }
        if (succ) {
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"No player with that name was found!"));
        return 0;
    }

    public static class FakenameArgumentType
    implements ArgumentType<String> {
        public static FakenameArgumentType fakename() {
            return new FakenameArgumentType();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            Object object = context.getSource();
            if (object instanceof CommandSourceStack) {
                CommandSourceStack cs = (CommandSourceStack)object;
                PlayerList players = cs.m_81377_().m_6846_();
                for (Player player : players.m_11314_()) {
                    if (player.getPersistentData() == null || !player.getPersistentData().m_128441_("fakename")) continue;
                    Object name = ChatFormatting.m_126649_((String)player.getPersistentData().m_128461_("fakename"));
                    name = ((String)name).contains(" ") ? "\"" + (String)name + "\"" : name;
                    builder.suggest((String)name);
                }
                return builder.buildFuture();
            }
            if (context.getSource() instanceof SharedSuggestionProvider) {
                return ((SharedSuggestionProvider)context.getSource()).m_212155_(context);
            }
            return Suggestions.empty();
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readString();
        }
    }
}

