/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.AddCategoryPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RemoveCategoryPacket;
import de.maxhenkel.voicechat.plugins.CategoryManager;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.server.Server;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerCategoryManager
extends CategoryManager {
    private final Server server;

    public ServerCategoryManager(Server server) {
        this.server = server;
    }

    public void onPlayerCompatibilityCheckSucceeded(ServerPlayer player) {
        Voicechat.LOGGER.debug("Synchronizing {} volume categories with {}", this.categories.size(), player.m_5446_().getString());
        for (VolumeCategoryImpl category : this.getCategories()) {
            this.broadcastAddCategory(this.server.getServer(), category);
        }
    }

    @Override
    public void addCategory(VolumeCategoryImpl category) {
        super.addCategory(category);
        Voicechat.LOGGER.debug("Synchronizing volume category {} with all players", category.getId());
        this.broadcastAddCategory(this.server.getServer(), category);
    }

    @Override
    @Nullable
    public VolumeCategoryImpl removeCategory(String categoryId) {
        VolumeCategoryImpl volumeCategory = super.removeCategory(categoryId);
        Voicechat.LOGGER.debug("Removing volume category {} for all players", categoryId);
        this.broadcastRemoveCategory(this.server.getServer(), categoryId);
        return volumeCategory;
    }

    private void broadcastAddCategory(MinecraftServer server, VolumeCategoryImpl category) {
        AddCategoryPacket packet = new AddCategoryPacket(category);
        server.m_6846_().m_11314_().forEach(p -> NetManager.sendToClient(p, packet));
    }

    private void broadcastRemoveCategory(MinecraftServer server, String categoryId) {
        RemoveCategoryPacket packet = new RemoveCategoryPacket(categoryId);
        server.m_6846_().m_11314_().forEach(p -> NetManager.sendToClient(p, packet));
    }
}

