/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.util.math;

import com.github.NGoedix.watchvideo.util.math.Axis;
import com.github.NGoedix.watchvideo.util.math.VecNf;

public class Vec3f
extends VecNf<Vec3f> {
    public float x;
    public float y;
    public float z;

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(Vec3f vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    @Override
    public float get(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
        };
    }

    @Override
    public float get(int dim) {
        return switch (dim) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> 0.0f;
        };
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void set(int dim, float value) {
        switch (dim) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
            }
        }
    }

    @Override
    public void set(Axis axis, float value) {
        switch (axis) {
            case X: {
                this.x = value;
                break;
            }
            case Y: {
                this.y = value;
                break;
            }
            case Z: {
                this.z = value;
            }
        }
    }

    @Override
    public int dimensions() {
        return 3;
    }

    @Override
    public void add(Vec3f vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Vec3f)) {
            return false;
        }
        return ((Vec3f)obj).x == this.x && ((Vec3f)obj).y == this.y && ((Vec3f)obj).z == this.z;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

