/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.util.math;

import com.github.NGoedix.watchvideo.util.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Facing {
    DOWN(Axis.Y, false, new Vec3i(0, -1, 0), -1){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82289_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252392_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165887_(value);
        }
    }
    ,
    UP(Axis.Y, true, new Vec3i(0, 1, 0), -1){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82292_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252436_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165893_(value);
        }
    }
    ,
    NORTH(Axis.Z, false, new Vec3i(0, 0, -1), 2){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82290_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252393_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165889_(value);
        }
    }
    ,
    SOUTH(Axis.Z, true, new Vec3i(0, 0, 1), 0){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82293_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252403_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165895_(value);
        }
    }
    ,
    WEST(Axis.X, false, new Vec3i(-1, 0, 0), 1){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82288_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252495_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165880_(value);
        }
    }
    ,
    EAST(Axis.X, true, new Vec3i(1, 0, 0), 3){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82291_;
        }

        @Override
        public com.mojang.math.Axis rotation() {
            return com.mojang.math.Axis.f_252529_;
        }

        @Override
        public AABB set(AABB bb, double value) {
            return bb.m_165891_(value);
        }
    };

    public static final Facing[] VALUES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final Vec3i normal;
    public final int horizontalIndex;

    public static Facing get(int index) {
        return VALUES[index];
    }

    public static Facing get(Direction direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public static Facing get(Axis axis, boolean positive) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (positive) {
                    yield EAST;
                }
                yield WEST;
            }
            case Axis.Y -> {
                if (positive) {
                    yield UP;
                }
                yield DOWN;
            }
            case Axis.Z -> positive ? SOUTH : NORTH;
        };
    }

    private Facing(Axis axis, boolean positive, Vec3i normal, int horizontalIndex) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.horizontalIndex = horizontalIndex;
    }

    public abstract Facing opposite();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public abstract double get(AABB var1);

    public abstract AABB set(AABB var1, double var2);

    public abstract com.mojang.math.Axis rotation();

    static {
        VALUES = new Facing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }
}

