/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.util.math;

import com.github.NGoedix.watchvideo.util.math.Axis;
import com.github.NGoedix.watchvideo.util.math.BoxCorner;
import com.github.NGoedix.watchvideo.util.math.Facing;
import com.github.NGoedix.watchvideo.util.math.Vec3d;

public enum BoxFace {
    EAST(Facing.EAST, new BoxCorner[]{BoxCorner.EUS, BoxCorner.EDS, BoxCorner.EDN, BoxCorner.EUN}, Facing.NORTH, Facing.DOWN),
    WEST(Facing.WEST, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WDN, BoxCorner.WDS, BoxCorner.WUS}, Facing.SOUTH, Facing.DOWN),
    UP(Facing.UP, new BoxCorner[]{BoxCorner.WUN, BoxCorner.WUS, BoxCorner.EUS, BoxCorner.EUN}, Facing.EAST, Facing.SOUTH),
    DOWN(Facing.DOWN, new BoxCorner[]{BoxCorner.WDS, BoxCorner.WDN, BoxCorner.EDN, BoxCorner.EDS}, Facing.EAST, Facing.NORTH),
    SOUTH(Facing.SOUTH, new BoxCorner[]{BoxCorner.WUS, BoxCorner.WDS, BoxCorner.EDS, BoxCorner.EUS}, Facing.EAST, Facing.DOWN),
    NORTH(Facing.NORTH, new BoxCorner[]{BoxCorner.EUN, BoxCorner.EDN, BoxCorner.WDN, BoxCorner.WUN}, Facing.WEST, Facing.DOWN);

    public final Facing facing;
    public final BoxCorner[] corners;
    private final Facing texU;
    private final Facing texV;

    private BoxFace(Facing facing, BoxCorner[] corners, Facing texU, Facing texV) {
        this.facing = facing;
        this.corners = corners;
        this.texU = texU;
        this.texV = texV;
    }

    public Facing getTexU() {
        return this.texU;
    }

    public Facing getTexV() {
        return this.texV;
    }

    public Vec3d first(Vec3d[] corners) {
        return corners[this.corners[0].ordinal()];
    }

    public static BoxFace get(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> EAST;
            case Facing.WEST -> WEST;
            case Facing.UP -> UP;
            case Facing.DOWN -> DOWN;
            case Facing.SOUTH -> SOUTH;
            case Facing.NORTH -> NORTH;
        };
    }

    public static BoxFace get(Axis axis, boolean direction) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (direction) {
                    yield EAST;
                }
                yield WEST;
            }
            case Axis.Y -> {
                if (direction) {
                    yield UP;
                }
                yield DOWN;
            }
            case Axis.Z -> direction ? SOUTH : NORTH;
        };
    }
}

