/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.util.math;

import com.github.NGoedix.watchvideo.util.math.Axis;
import com.github.NGoedix.watchvideo.util.math.Facing;
import com.github.NGoedix.watchvideo.util.math.Vec3d;
import net.minecraft.world.phys.AABB;

public final class BoxCorner
extends Enum<BoxCorner> {
    public static final /* enum */ BoxCorner EUN;
    public static final /* enum */ BoxCorner EUS;
    public static final /* enum */ BoxCorner EDN;
    public static final /* enum */ BoxCorner EDS;
    public static final /* enum */ BoxCorner WUN;
    public static final /* enum */ BoxCorner WUS;
    public static final /* enum */ BoxCorner WDN;
    public static final /* enum */ BoxCorner WDS;
    public final Facing x;
    public final Facing y;
    public final Facing z;
    public BoxCorner neighborOne;
    public BoxCorner neighborTwo;
    public BoxCorner neighborThree;
    private static final /* synthetic */ BoxCorner[] $VALUES;

    public static BoxCorner[] values() {
        return (BoxCorner[])$VALUES.clone();
    }

    public static BoxCorner valueOf(String name) {
        return Enum.valueOf(BoxCorner.class, name);
    }

    private BoxCorner(Facing x, Facing y, Facing z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private void init() {
        this.neighborOne = BoxCorner.getCorner(this.x.opposite(), this.y, this.z);
        this.neighborTwo = BoxCorner.getCorner(this.x, this.y.opposite(), this.z);
        this.neighborThree = BoxCorner.getCorner(this.x, this.y, this.z.opposite());
    }

    public boolean isFacing(Facing facing) {
        return this.getFacing(facing.axis) == facing;
    }

    public Facing getFacing(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
        };
    }

    public Vec3d get(AABB bb) {
        return new Vec3d(this.x.get(bb), this.y.get(bb), this.z.get(bb));
    }

    public static BoxCorner getCorner(Facing x, Facing y, Facing z) {
        BoxCorner[] var3;
        for (BoxCorner corner : var3 = BoxCorner.values()) {
            if (corner.x != x || corner.y != y || corner.z != z) continue;
            return corner;
        }
        return null;
    }

    private static /* synthetic */ BoxCorner[] $values() {
        return new BoxCorner[]{EUN, EUS, EDN, EDS, WUN, WUS, WDN, WDS};
    }

    static {
        BoxCorner[] var0;
        EUN = new BoxCorner(Facing.EAST, Facing.UP, Facing.NORTH);
        EUS = new BoxCorner(Facing.EAST, Facing.UP, Facing.SOUTH);
        EDN = new BoxCorner(Facing.EAST, Facing.DOWN, Facing.NORTH);
        EDS = new BoxCorner(Facing.EAST, Facing.DOWN, Facing.SOUTH);
        WUN = new BoxCorner(Facing.WEST, Facing.UP, Facing.NORTH);
        WUS = new BoxCorner(Facing.WEST, Facing.UP, Facing.SOUTH);
        WDN = new BoxCorner(Facing.WEST, Facing.DOWN, Facing.NORTH);
        WDS = new BoxCorner(Facing.WEST, Facing.DOWN, Facing.SOUTH);
        $VALUES = BoxCorner.$values();
        for (BoxCorner corner : var0 = BoxCorner.values()) {
            corner.init();
        }
    }
}

