/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.network;

import com.github.NGoedix.watchvideo.network.message.FrameVideoMessage;
import com.github.NGoedix.watchvideo.network.message.IMessage;
import com.github.NGoedix.watchvideo.network.message.OpenVideoManagerScreen;
import com.github.NGoedix.watchvideo.network.message.SendVideoMessage;
import com.github.NGoedix.watchvideo.network.message.UploadVideoUpdateMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = "2";
    private static SimpleChannel INSTANCE;
    private static int nextId;

    public static void init() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("videoplayer", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketHandler.register(SendVideoMessage.class, new SendVideoMessage());
        PacketHandler.register(FrameVideoMessage.class, new FrameVideoMessage());
        PacketHandler.register(OpenVideoManagerScreen.class, new OpenVideoManagerScreen());
        PacketHandler.register(UploadVideoUpdateMessage.class, new UploadVideoUpdateMessage());
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message) {
        INSTANCE.registerMessage(nextId++, clazz, message::encode, message::decode, message::handle);
    }

    public static SimpleChannel getPlayChannel() {
        return INSTANCE;
    }

    public static <MSG> void sendTo(MSG msg, Player player) {
        INSTANCE.sendTo(msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToClient(MSG message, Level level, BlockPos pos) {
        PacketHandler.sendToClient(message, level.m_46745_(pos));
    }

    public static <MSG> void sendToClient(MSG msg, LevelChunk chunk) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public static <MSG> void sendToAllTracking(MSG msg, LivingEntity entityToTrack) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entityToTrack), msg);
    }

    public static <MSG> void sendToAll(MSG msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static <MSG> void sendToServer(MSG msg) {
        INSTANCE.sendToServer(msg);
    }

    static {
        nextId = 0;
    }
}

