/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

public class SymbolStringArgumentType
implements ArgumentType<String> {
    public static SymbolStringArgumentType symbolString() {
        return new SymbolStringArgumentType();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        while (reader.canRead() && this.isAllowedSymbol(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == start) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().createWithContext((ImmutableStringReader)reader, (Object)":/?=-%&_.");
        }
        return reader.getString().substring(start, reader.getCursor());
    }

    private boolean isAllowedSymbol(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == ':' || c == '/' || c == '?' || c == '=' || c == '.' || c == '%' || c == '&' || c == '_';
    }
}

