/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.client.render;

import com.github.NGoedix.watchvideo.block.custom.TVBlock;
import com.github.NGoedix.watchvideo.block.entity.custom.TVBlockEntity;
import com.github.NGoedix.watchvideo.util.displayers.IDisplay;
import com.github.NGoedix.watchvideo.util.math.AlignedBox;
import com.github.NGoedix.watchvideo.util.math.Axis;
import com.github.NGoedix.watchvideo.util.math.BoxCorner;
import com.github.NGoedix.watchvideo.util.math.BoxFace;
import com.github.NGoedix.watchvideo.util.math.Facing;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class TVBlockRenderer
implements BlockEntityRenderer<TVBlockEntity> {
    private static BufferedImage blackTextureBuffer = null;
    private static ImageRenderer blackTexture = null;

    public TVBlockRenderer(BlockEntityRendererProvider.Context dispatcher) {
        if (blackTextureBuffer == null) {
            blackTextureBuffer = new BufferedImage(1, 1, 2);
            blackTextureBuffer.setRGB(0, 0, Color.BLACK.getRGB());
            blackTexture = ImageAPI.renderer((BufferedImage)blackTextureBuffer);
        }
    }

    public boolean shouldRenderOffScreen(TVBlockEntity frame) {
        return frame.getSizeX() > 16.0f || frame.getSizeY() > 16.0f;
    }

    public boolean shouldRender(TVBlockEntity frame, @NotNull Vec3 vec) {
        return Vec3.m_82512_((Vec3i)frame.m_58899_()).m_82509_((Position)vec, 128.0);
    }

    public void render(TVBlockEntity frame, float pPartialTick, @NotNull PoseStack pose, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (frame.isURLEmpty()) {
            if (frame.display != null) {
                frame.display.release();
            }
            return;
        }
        IDisplay display = frame.requestDisplay();
        if (display == null) {
            if (!frame.isPlaying()) {
                return;
            }
            this.renderTexture(frame, null, ImageAPI.loadingGif().texture((int)Minecraft.m_91087_().f_91073_.m_46467_(), 1L, true), pose, true);
            return;
        }
        int texture = display.prepare(frame.getUrl(), frame.getVolume() * Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER), frame.minDistance, frame.maxDistance, frame.isPlaying(), frame.isLoop(), frame.getTick());
        if (texture == -1) {
            return;
        }
        this.renderTexture(frame, display, blackTexture.texture(1, 1L, false), pose, false);
        this.renderTexture(frame, display, texture, pose, true);
    }

    private void renderTexture(TVBlockEntity frame, IDisplay display, int texture, PoseStack pose, boolean aspectRatio) {
        float offset;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.bindTexture((int)texture);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        Direction d = (Direction)frame.m_58900_().m_61143_((Property)TVBlock.FACING);
        if (d == Direction.NORTH) {
            d = Direction.SOUTH;
        } else if (d == Direction.SOUTH) {
            d = Direction.NORTH;
        }
        Facing facing = Facing.get(d);
        AlignedBox box = frame.getBox();
        if (aspectRatio) {
            float difference;
            Dimension dimensions;
            float videoAspectRatio = 1.0f;
            if (display != null && (dimensions = display.getDimensions()) != null) {
                videoAspectRatio = (float)(dimensions.getWidth() / (double)((float)dimensions.getHeight()));
            }
            float height = box.maxY - box.minY;
            float width = 0.0f;
            switch (facing) {
                case WEST: 
                case EAST: {
                    width = box.maxZ - box.minZ;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    width = box.maxX - box.minX;
                }
            }
            float screenAspectRatio = width / height;
            float w = height * videoAspectRatio;
            float h = width / videoAspectRatio;
            if (videoAspectRatio > screenAspectRatio) {
                box.setMax(Axis.Y, h);
                pose.m_252880_(0.0f, (height - h) / 2.0f, 0.0f);
            } else {
                box.setMax(facing.axis == Axis.Z ? Axis.X : Axis.Z, w);
                pose.m_252880_(facing.axis == Axis.Z ? (width - w) / 2.0f : 0.0f, 0.0f, facing.axis == Axis.Z ? 0.0f : (width - w) / 2.0f);
            }
            if (facing == Facing.SOUTH) {
                box.setMax(Axis.X, box.maxX - 0.02f);
            }
            if ((difference = height - width) > 0.0f) {
                box.grow(Axis.Y, -difference / 2.0f);
                if (facing.axis == Axis.Z) {
                    box.grow(Axis.X, difference / 2.0f);
                } else {
                    box.grow(Axis.Z, difference / 2.0f);
                }
            }
        }
        float f = offset = aspectRatio ? 0.001f : 0.0f;
        if (d == Direction.WEST || d == Direction.EAST) {
            box.grow(facing.axis, 0.99f + offset);
        } else {
            box.grow(facing.axis, -0.95f + offset);
        }
        BoxFace face = BoxFace.get(facing);
        pose.m_85836_();
        if (d == Direction.NORTH) {
            pose.m_85837_(-0.185, 0.0, 0.0);
        }
        if (d == Direction.SOUTH) {
            pose.m_85837_(-0.185, 0.0, 0.0);
        }
        if (d == Direction.WEST) {
            pose.m_85837_(0.0, 0.0, -0.185);
        }
        if (d == Direction.EAST) {
            pose.m_85837_(0.0, 0.0, -0.185);
        }
        pose.m_85837_(0.5, 0.5646, 0.5);
        pose.m_252781_(facing.rotation().m_252961_((float)Math.toRadians(0.0)));
        pose.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f mat = pose.m_85850_().m_252922_();
        Matrix3f mat3f = pose.m_85850_().m_252943_();
        Vec3i normal = face.facing.normal;
        for (BoxCorner corner : face.corners) {
            builder.m_252986_(mat, box.get(corner.x), box.get(corner.y), box.get(corner.z)).m_7421_(corner.isFacing(face.getTexU()) ? 1.0f : 0.0f, corner.isFacing(face.getTexV()) ? 1.0f : 0.0f).m_193479_(-1).m_252939_(mat3f, (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        }
        tesselator.m_85914_();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        pose.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }
}

