/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.client.gui;

import com.github.NGoedix.watchvideo.Reference;
import com.github.NGoedix.watchvideo.VideoPlayer;
import com.github.NGoedix.watchvideo.client.gui.DummyContainer;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import me.lib720.caprica.vlcj.player.base.State;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.api.player.SyncVideoPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class VideoScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    private static final DateFormat FORMAT = new SimpleDateFormat("HH:mm:ss");
    int tick = 0;
    int closingOnTick = -1;
    float fadeLevel = 0.0f;
    boolean started;
    boolean closing = false;
    boolean paused = false;
    float volume;
    boolean controlBlocked;
    private final SyncVideoPlayer player;
    int videoTexture = -1;

    protected void m_7856_() {
        if (Minecraft.m_91087_().f_91080_ != null) {
            this.f_97726_ = Minecraft.m_91087_().f_91080_.f_96543_;
            this.f_97727_ = Minecraft.m_91087_().f_91080_.f_96544_;
        }
        super.m_7856_();
    }

    public VideoScreen(String url, int volume, boolean controlBlocked) {
        super((AbstractContainerMenu)new DummyContainer(), Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_150109_(), (Component)Component.m_237113_((String)""));
        Minecraft minecraft = Minecraft.m_91087_();
        Minecraft.m_91087_().m_91106_().m_120391_();
        this.volume = volume;
        this.controlBlocked = controlBlocked;
        this.player = new SyncVideoPlayer(null, (Executor)minecraft, MemoryTracker::m_182527_);
        Reference.LOGGER.info("Playing video (" + (!controlBlocked ? "not" : "") + "blocked) (" + url + " with volume: " + (int)(Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER) * (float)volume));
        this.player.setVolume((int)(Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER) * (float)volume));
        this.player.start((CharSequence)url);
        this.started = true;
    }

    protected void m_280003_(@NotNull GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        if (!this.started) {
            return;
        }
        this.videoTexture = this.player.prepareTexture();
        if ((this.player.isEnded() || this.player.isStopped() || this.player.getRawPlayerState().equals((Object)State.ERROR)) && (this.fadeLevel == 1.0f || this.closing)) {
            this.closing = true;
            if (this.closingOnTick == -1) {
                this.closingOnTick = this.tick + 20;
            }
            if (this.tick >= this.closingOnTick) {
                this.fadeLevel = Math.max(this.fadeLevel - pPartialTick / 8.0f, 0.0f);
            }
            this.renderBlackBackground(guiGraphics);
            this.renderIcon(guiGraphics, ImageAPI.loadingGif());
            if (this.fadeLevel == 0.0f) {
                this.m_7379_();
            }
            return;
        }
        boolean playingState = !(!this.player.isPlaying() && !this.player.isPaused() || !this.player.getRawPlayerState().equals((Object)State.PLAYING) && !this.player.getRawPlayerState().equals((Object)State.PAUSED));
        float f = this.fadeLevel = playingState ? Math.max(this.fadeLevel - pPartialTick / 8.0f, 0.0f) : Math.min(this.fadeLevel + pPartialTick / 16.0f, 1.0f);
        if (playingState || this.player.isStopped() || this.player.isEnded()) {
            this.renderTexture(guiGraphics, this.videoTexture);
        }
        if (!this.paused) {
            this.renderBlackBackground(guiGraphics);
        }
        if (!this.player.isPlaying() || !this.player.getRawPlayerState().equals((Object)State.PLAYING)) {
            if (this.player.isPaused() && this.player.getRawPlayerState().equals((Object)State.PAUSED)) {
                this.renderIcon(guiGraphics, VideoPlayer.pausedImage());
            } else {
                this.renderIcon(guiGraphics, ImageAPI.loadingGif());
            }
        }
        if (!FMLLoader.isProduction()) {
            this.draw(guiGraphics, String.format("State: %s", this.player.getRawPlayerState().name()), this.getHeightCenter(-12));
            this.draw(guiGraphics, String.format("Time: %s (%s) / %s (%s)", FORMAT.format(new Date(this.player.getTime())), this.player.getTime(), FORMAT.format(new Date(this.player.getDuration())), this.player.getDuration()), this.getHeightCenter(0));
            this.draw(guiGraphics, String.format("Media Duration: %s (%s)", FORMAT.format(new Date(this.player.getMediaInfoDuration())), this.player.getMediaInfoDuration()), this.getHeightCenter(12));
        }
    }

    private void renderTexture(GuiGraphics guiGraphics, int texture) {
        int renderHeight;
        int renderWidth;
        if (this.player.getDimensions() == null) {
            return;
        }
        RenderSystem.enableBlend();
        guiGraphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, WaterMediaAPI.math_colorARGB((int)255, (int)0, (int)0, (int)0));
        RenderSystem.disableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)texture);
        Dimension videoDimensions = this.player.getDimensions();
        double videoWidth = videoDimensions.getWidth();
        double videoHeight = videoDimensions.getHeight();
        float screenAspectRatio = (float)this.f_97726_ / (float)this.f_97727_;
        float videoAspectRatio = (float)((double)((float)videoWidth) / videoHeight);
        if (videoAspectRatio > screenAspectRatio) {
            renderWidth = this.f_97726_;
            renderHeight = (int)((float)this.f_97726_ / videoAspectRatio);
        } else {
            renderWidth = (int)((float)this.f_97727_ * videoAspectRatio);
            renderHeight = this.f_97727_;
        }
        int xOffset = (this.f_97726_ - renderWidth) / 2;
        int yOffset = (this.f_97727_ - renderHeight) / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)xOffset, (float)yOffset, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)xOffset, (float)(yOffset + renderHeight), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(xOffset + renderWidth), (float)(yOffset + renderHeight), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(xOffset + renderWidth), (float)yOffset, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    private void renderBlackBackground(GuiGraphics stack) {
        RenderSystem.enableBlend();
        stack.m_280509_(0, 0, this.f_96543_, this.f_96544_, WaterMediaAPI.math_colorARGB((int)((int)(this.fadeLevel * 255.0f)), (int)0, (int)0, (int)0));
        RenderSystem.disableBlend();
    }

    private int getHeightCenter(int offset) {
        return this.f_96544_ / 2 + offset;
    }

    private void renderIcon(GuiGraphics guiGraphics, ImageRenderer image) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)image.texture(this.tick, 1L, true));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)this.f_96543_ - 36.0f, (float)this.f_96544_ - 36.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)this.f_96543_ - 36.0f, (float)this.f_96544_, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)this.f_96543_, (float)this.f_96544_, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)this.f_96543_, (float)this.f_96544_ - 36.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.disableBlend();
    }

    private void draw(GuiGraphics stack, String text, int height) {
        stack.m_280488_(Minecraft.m_91087_().f_91062_, text, 5, height, 0xFFFFFF);
    }

    protected void m_181908_() {
        super.m_181908_();
        ++this.tick;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        float newVolume;
        float actualVolume;
        if (VideoScreen.m_96638_() && pKeyCode == 256) {
            this.m_7379_();
        }
        if (pKeyCode == 265) {
            if (this.volume <= 95.0f) {
                this.volume += 5.0f;
            } else {
                this.volume = 100.0f;
                float masterVolume = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
                if ((double)masterVolume <= 0.95) {
                    Minecraft.m_91087_().f_91066_.m_246669_(SoundSource.MASTER).m_231514_((Object)(masterVolume + 0.05f));
                } else {
                    Minecraft.m_91087_().f_91066_.m_246669_(SoundSource.MASTER).m_231514_((Object)1.0);
                }
            }
            actualVolume = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
            newVolume = this.volume * actualVolume;
            Reference.LOGGER.info("Volume UP to: " + newVolume);
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 264) {
            this.volume = this.volume >= 5.0f ? (this.volume -= 5.0f) : 0.0f;
            actualVolume = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
            newVolume = this.volume * actualVolume;
            Reference.LOGGER.info("Volume DOWN to: " + newVolume);
            this.player.setVolume((int)newVolume);
        }
        if (pKeyCode == 77) {
            if (!this.player.raw().mediaPlayer().audio().isMute()) {
                this.player.mute();
            } else {
                this.player.unmute();
            }
        }
        if (this.controlBlocked) {
            return super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        if (VideoScreen.m_96638_() && pKeyCode == 262) {
            this.player.seekTo(this.player.getTime() + 30000L);
        }
        if (VideoScreen.m_96638_() && pKeyCode == 263) {
            this.player.seekTo(this.player.getTime() - 10000L);
        }
        if (VideoScreen.m_96638_() && pKeyCode == 32) {
            if (!this.player.isPaused()) {
                this.paused = true;
                this.player.pause();
            } else {
                this.paused = false;
                this.player.play();
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.started) {
            this.started = false;
            this.player.stop();
            Minecraft.m_91087_().m_91106_().m_120407_();
            GlStateManager._deleteTexture((int)this.videoTexture);
            this.player.release();
        }
    }

    static {
        FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }
}

