/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo.block.entity.custom;

import com.github.NGoedix.watchvideo.block.custom.TVBlock;
import com.github.NGoedix.watchvideo.block.entity.ModBlockEntities;
import com.github.NGoedix.watchvideo.network.PacketHandler;
import com.github.NGoedix.watchvideo.network.message.FrameVideoMessage;
import com.github.NGoedix.watchvideo.network.message.OpenVideoManagerScreen;
import com.github.NGoedix.watchvideo.util.cache.TextureCache;
import com.github.NGoedix.watchvideo.util.displayers.IDisplay;
import com.github.NGoedix.watchvideo.util.math.AlignedBox;
import com.github.NGoedix.watchvideo.util.math.Axis;
import com.github.NGoedix.watchvideo.util.math.Facing;
import com.github.NGoedix.watchvideo.util.math.Vec3d;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TVBlockEntity
extends BlockEntity {
    private String url = "";
    private boolean playing = false;
    private int tick = 0;
    private float volume = 1.0f;
    public float minDistance = 5.0f;
    public float maxDistance = 20.0f;
    private boolean loop = true;
    private UUID playerUsing;
    @OnlyIn(value=Dist.CLIENT)
    public IDisplay display;
    @OnlyIn(value=Dist.CLIENT)
    public TextureCache cache;

    public TVBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TV_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isURLEmpty() {
        return this.url.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void setVolume(int volume) {
        this.volume = (float)volume / 100.0f;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public float getVolume() {
        return this.volume;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public IDisplay requestDisplay() {
        String url = this.getUrl();
        if (this.isURLEmpty()) {
            return null;
        }
        if (this.cache == null || !this.cache.url.equals(url)) {
            this.cache = TextureCache.get(url);
            if (this.display != null) {
                this.display.release();
            }
            this.display = null;
        }
        if (!(this.cache.isVideo() || this.cache.ready() && this.cache.getError() == null)) {
            return null;
        }
        if (this.display != null) {
            return this.display;
        }
        this.display = this.cache.createDisplay(new Vec3d((Vec3i)this.f_58858_), url, this.volume, this.minDistance, this.maxDistance, this.loop, this.playing);
        return this.display;
    }

    public void tryOpen(Level level, BlockPos blockPos, Player player) {
        if (this.playerUsing == null) {
            this.setBeingUsed(player.m_20148_());
            this.openVideoManagerGUI(blockPos, player);
            return;
        }
        for (Player p : level.m_6907_()) {
            if (p.m_20148_() != this.playerUsing) continue;
            return;
        }
        this.openVideoManagerGUI(blockPos, player);
    }

    public void openVideoManagerGUI(BlockPos blockPos, Player player) {
        this.setBeingUsed(player.m_20148_());
        PacketHandler.sendTo(new OpenVideoManagerScreen(blockPos, this.url, this.tick, (int)(this.volume * 100.0f), this.loop), player);
    }

    public void setBeingUsed(UUID player) {
        this.playerUsing = player;
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.loadFromNBT(nbt);
        this.f_58857_.m_151543_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof TVBlockEntity) {
            IDisplay display;
            TVBlockEntity be = (TVBlockEntity)blockEntity;
            if (level.f_46443_ && (display = be.requestDisplay()) != null) {
                display.tick(be.url, be.volume, be.minDistance, be.maxDistance, be.playing, be.loop, be.tick);
            }
            if (be.playing) {
                ++be.tick;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TVBlock.LIT, (Comparable)Boolean.valueOf(be.playing)), 3);
        }
    }

    public void m_7651_() {
        if (this.isClient() && this.display != null) {
            this.display.release();
        }
    }

    public void onChunkUnloaded() {
        if (this.isClient() && this.display != null) {
            this.display.release();
        }
    }

    public boolean isClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_("url", this.url == null ? "" : this.url);
        pTag.m_128362_("beingUsed", this.playerUsing == null ? new UUID(0L, 0L) : this.playerUsing);
        pTag.m_128379_("playing", this.playing);
        pTag.m_128405_("tick", this.tick);
        pTag.m_128350_("volume", this.volume);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.loadFromNBT(pTag);
    }

    private void loadFromNBT(CompoundTag nbt) {
        this.url = nbt.m_128461_("url");
        this.playerUsing = nbt.m_128342_("beingUsed");
        this.playing = nbt.m_128471_("playing");
        this.tick = nbt.m_128451_("tick");
        this.volume = nbt.m_128457_("volume");
    }

    public void notifyPlayer() {
        PacketHandler.sendToClient(new FrameVideoMessage(this.f_58858_, this.playing, this.tick), this.f_58857_, this.f_58858_);
    }

    public float getSizeX() {
        return 1.4f;
    }

    public float getSizeY() {
        return 0.81f;
    }

    public AlignedBox getBox() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)TVBlock.FACING);
        Facing facing = Facing.get(direction);
        AlignedBox box = TVBlock.box(direction);
        Axis one = facing.one();
        Axis two = facing.two();
        if (facing.axis != Axis.Z) {
            one = facing.two();
            two = facing.one();
        }
        box.setMin(one, 0.0f);
        box.setMax(one, this.getSizeX());
        box.setMin(two, 0.0f);
        box.setMax(two, this.getSizeY());
        return box;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.m_58900_().m_61124_((Property)TVBlock.LIT, (Comparable)Boolean.valueOf(playing));
        this.playing = playing;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }
}

