/*
 * Decompiled with CFR 0.152.
 */
package com.github.NGoedix.watchvideo;

import com.github.NGoedix.watchvideo.Reference;
import com.github.NGoedix.watchvideo.block.ModBlocks;
import com.github.NGoedix.watchvideo.block.entity.ModBlockEntities;
import com.github.NGoedix.watchvideo.client.render.TVBlockRenderer;
import com.github.NGoedix.watchvideo.commands.RegisterCommands;
import com.github.NGoedix.watchvideo.commands.arguments.SymbolStringArgumentSerializer;
import com.github.NGoedix.watchvideo.commands.arguments.SymbolStringArgumentType;
import com.github.NGoedix.watchvideo.common.CommonHandler;
import com.github.NGoedix.watchvideo.common.ModCreativeTabs;
import com.github.NGoedix.watchvideo.item.ModItems;
import com.github.NGoedix.watchvideo.util.cache.TextureCache;
import com.github.NGoedix.watchvideo.util.displayers.VideoDisplayer;
import java.awt.image.BufferedImage;
import me.srrapero720.watermedia.api.image.ImageAPI;
import me.srrapero720.watermedia.api.image.ImageRenderer;
import me.srrapero720.watermedia.core.tools.JarTool;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="videoplayer")
public class VideoPlayer {
    @OnlyIn(value=Dist.CLIENT)
    private static ImageRenderer IMG_PAUSED;

    @OnlyIn(value=Dist.CLIENT)
    public static ImageRenderer pausedImage() {
        return IMG_PAUSED;
    }

    public VideoPlayer() {
        Reference.LOGGER.info("Initializing mod...");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register(RegisterCommands.class);
        ModBlocks.register(eventBus);
        ModItems.register(eventBus);
        ModBlockEntities.register(eventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(eventBus);
        eventBus.addListener(this::onCommonSetup);
        eventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        ArgumentTypeInfos.registerByClass(SymbolStringArgumentType.class, (ArgumentTypeInfo)new SymbolStringArgumentSerializer());
        event.enqueueWork(CommonHandler::setup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TV_BLOCK.get()), (RenderType)RenderType.m_110463_());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.TV_BLOCK_ENTITY.get()), TVBlockRenderer::new);
        this.loadImages();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void loadImages() {
        IMG_PAUSED = ImageAPI.renderer((BufferedImage)JarTool.readImage((ClassLoader)VideoPlayer.class.getClassLoader(), (String)"/pictures/paused.png"), (boolean)true);
    }

    @Mod.EventBusSubscriber(modid="videoplayer", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class Events {
        @SubscribeEvent
        public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                TextureCache.renderTick();
            }
        }

        @SubscribeEvent
        public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                TextureCache.clientTick();
                VideoDisplayer.tick();
            }
        }

        @SubscribeEvent
        public static void onUnloadingLevel(LevelEvent.Unload unload) {
            if (unload.getLevel() != null && unload.getLevel().m_5776_()) {
                TextureCache.unload();
                VideoDisplayer.unload();
            }
        }
    }
}

