/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.keybinding;

import java.util.Optional;
import net.kyrptonaught.jankson.JsonElement;
import net.kyrptonaught.jankson.JsonPrimitive;
import net.kyrptonaught.kyrptconfig.config.CustomMarshaller;
import net.kyrptonaught.kyrptconfig.config.CustomSerializable;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class CustomKeyBinding
implements CustomSerializable {
    public boolean unknownIsActivated = false;
    public String rawKey = "";
    public String defaultKey = "";
    public class_3675.class_306 parsedKey;
    public boolean doParseKey = true;
    private final String MOD_ID;
    boolean holding = false;

    public CustomKeyBinding(String MOD_ID) {
        this.MOD_ID = MOD_ID;
    }

    public CustomKeyBinding(String MOD_ID, boolean unknownIsActivated) {
        this.unknownIsActivated = unknownIsActivated;
        this.MOD_ID = MOD_ID;
    }

    public static CustomKeyBinding configDefault(String MOD_ID, String defaultKey) {
        CustomKeyBinding customKeyBinding = new CustomKeyBinding(MOD_ID).setRaw(defaultKey);
        customKeyBinding.defaultKey = defaultKey;
        return customKeyBinding;
    }

    public CustomKeyBinding setRaw(String key) {
        this.rawKey = key;
        this.doParseKey = true;
        this.holding = false;
        return this;
    }

    public boolean wasPressed() {
        boolean pressed = this.isKeybindPressed();
        if (!this.holding) {
            this.holding = pressed;
            return pressed;
        }
        if (!pressed) {
            this.holding = false;
        }
        return false;
    }

    private void parseKeycode() {
        if (this.doParseKey) {
            this.parsedKey = this.getKeybinding().orElse(null);
            this.doParseKey = false;
        }
    }

    public boolean isKeybindPressed() {
        this.parseKeycode();
        if (this.parsedKey == null) {
            return false;
        }
        if (this.parsedKey == class_3675.field_16237) {
            return this.unknownIsActivated;
        }
        boolean pressed = this.parsedKey.method_1442() == class_3675.class_307.field_1672 ? GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)this.parsedKey.method_1444()) == 1 : GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)this.parsedKey.method_1444()) == 1;
        return pressed;
    }

    public boolean matches(int keyCode, class_3675.class_307 type) {
        this.parseKeycode();
        if (this.parsedKey == null) {
            return false;
        }
        return this.parsedKey.method_1442() == type && this.parsedKey.method_1444() == keyCode;
    }

    public Optional<class_3675.class_306> getKeybinding() {
        if (this.rawKey.isEmpty()) {
            return Optional.of(class_3675.field_16237);
        }
        try {
            return Optional.of(class_3675.method_15981((String)this.rawKey));
        }
        catch (IllegalArgumentException e) {
            System.out.println(this.MOD_ID + ": unknown key entered");
            return Optional.empty();
        }
    }

    public class_3675.class_306 getDefaultKey() {
        if (this.defaultKey == null || this.defaultKey.isEmpty()) {
            return class_3675.field_16237;
        }
        try {
            return class_3675.method_15981((String)this.defaultKey);
        }
        catch (IllegalArgumentException e) {
            System.out.println(this.MOD_ID + ": unknown default key entered");
            return class_3675.field_16237;
        }
    }

    @Override
    public JsonElement toJson(CustomMarshaller m) {
        return new JsonPrimitive(this.rawKey);
    }

    @Override
    public CustomSerializable fromJson(CustomMarshaller m, JsonElement obj, Class<CustomSerializable> clazz) {
        if (obj instanceof JsonPrimitive) {
            JsonPrimitive string = (JsonPrimitive)obj;
            this.setRaw(string.asString());
        }
        return this;
    }
}

