/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config.screen.items;

import java.util.ArrayList;
import java.util.List;
import net.kyrptonaught.kyrptconfig.config.screen.items.ConfigItem;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class SubItem<E>
extends ConfigItem<E> {
    protected boolean expanded = false;
    protected int subStart = 0;
    protected List<ConfigItem<?>> configs = new ArrayList();

    public SubItem(class_2561 name, boolean isExpanded) {
        super(name, null, null);
        this.expanded = isExpanded;
    }

    public SubItem(class_2561 name) {
        this(name, false);
    }

    @Override
    public boolean requiresRestart() {
        for (ConfigItem<?> item : this.configs) {
            if (!item.requiresRestart()) continue;
            return true;
        }
        return super.requiresRestart();
    }

    @Override
    public void save() {
        for (ConfigItem<?> item : this.configs) {
            item.save();
        }
        super.save();
    }

    @Override
    public boolean isValueDefault() {
        for (ConfigItem<?> item : this.configs) {
            if (item.isValueDefault()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void tick() {
        for (ConfigItem<?> item : this.configs) {
            if (item.isHidden()) continue;
            item.tick();
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (!this.isHidden() && mouseY > (double)this.subStart && mouseY < (double)(this.subStart + 20)) {
            boolean bl = this.expanded = !this.expanded;
        }
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                item.mouseClicked(mouseX, mouseY, button);
            }
        }
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden() || !item.charTyped(chr, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.expanded && !this.isHidden()) {
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden() || !item.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getContentSize() {
        if (this.expanded && !this.isHidden()) {
            int size = 0;
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                size += item.getSize() + 3;
            }
            return size;
        }
        return 0;
    }

    public void clearConfigItems() {
        this.configs.clear();
    }

    public ConfigItem<?> addConfigItem(ConfigItem<?> item) {
        this.configs.add(item);
        return item;
    }

    @Override
    public void render(class_4587 matrices, int x, int y, int mouseX, int mouseY, float delta) {
        super.render(matrices, x, y, mouseX, mouseY, delta);
        if (this.isHidden()) {
            return;
        }
        class_310.method_1551().field_1772.method_1729(matrices, this.expanded ? "-" : "+", (float)(x - 10), (float)(y + 5), 0xFFFFFF);
        this.subStart = y;
        if (this.expanded) {
            int runningY = this.subStart + 23;
            for (ConfigItem<?> item : this.configs) {
                if (item.isHidden()) continue;
                item.render(matrices, 30, runningY, mouseX, mouseY, delta);
                runningY += item.getSize() + 3;
            }
        }
    }
}

