/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.kyrptonaught.jankson.Jankson;
import net.kyrptonaught.jankson.JsonObject;
import net.kyrptonaught.kyrptconfig.config.AbstractConfigFile;

public class ConfigStorage {
    private final Path saveFile;
    public AbstractConfigFile config;
    private final AbstractConfigFile defaultConfig;

    public ConfigStorage(Path fileName, AbstractConfigFile defaultConfig) {
        this.saveFile = fileName;
        this.defaultConfig = defaultConfig;
    }

    public void save(String MOD_ID, Jankson JANKSON) {
        try (OutputStream os = Files.newOutputStream(this.saveFile, new OpenOption[0]);
             OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            String json = JANKSON.toJson(this.config).toJson(true, true);
            out.write(json);
        }
        catch (Exception e) {
            System.out.println(this.getConfigName(MOD_ID, "Failed to save #CONFIG"));
        }
    }

    public AbstractConfigFile load(String MOD_ID, Jankson JANKSON) {
        if (!Files.exists(this.saveFile, new LinkOption[0]) || !Files.isReadable(this.saveFile)) {
            System.out.println(this.getConfigName(MOD_ID, "Unable to find #CONFIG! Creating a default config"));
            this.config = this.defaultConfig;
            return this.config;
        }
        boolean failed = false;
        try (InputStream in = Files.newInputStream(this.saveFile, StandardOpenOption.READ);){
            JsonObject configJson = JANKSON.load(in);
            String regularized = configJson.toJson(false, false, 0);
            this.config = (AbstractConfigFile)JANKSON.fromJson(regularized, this.defaultConfig.getClass());
        }
        catch (Exception e) {
            failed = true;
        }
        if (failed || this.config == null) {
            System.out.println(this.getConfigName(MOD_ID, "Failed to load #CONFIG! Overwriting with default config"));
            this.config = this.defaultConfig;
        }
        return this.config;
    }

    public AbstractConfigFile getDefaultConfig() {
        return this.defaultConfig;
    }

    private String getConfigName(String MOD_ID, String message) {
        return "[" + MOD_ID + "]: " + message.replaceAll("#CONFIG", "config: " + this.saveFile.getFileName().toString());
    }
}

