/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import com.google.common.base.MoreObjects;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.fabric.RegistriesImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class Registries {
    private static final Map<String, Registries> REGISTRIES = new ConcurrentHashMap<String, Registries>();
    private final RegistryProvider provider;
    private final String modId;

    public static Registries get(String modId) {
        return REGISTRIES.computeIfAbsent(modId, Registries::new);
    }

    private Registries(String modId) {
        this.provider = Registries._get(modId);
        this.modId = modId;
    }

    public <T> Registrar<T> get(class_5321<class_2378<T>> key) {
        return this.provider.get(key);
    }

    @Deprecated
    public <T> Registrar<T> get(class_2378<T> registry) {
        return this.provider.get(registry);
    }

    public <T> void forRegistry(class_5321<class_2378<T>> key, Consumer<Registrar<T>> callback) {
        this.provider.forRegistry(key, callback);
    }

    @SafeVarargs
    public final <T> RegistrarBuilder<T> builder(class_2960 registryId, T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return this.provider.builder(typeGetter.getClass().getComponentType(), registryId);
    }

    @Nullable
    public static <T> class_2960 getId(T object, @Nullable class_5321<class_2378<T>> fallback) {
        if (fallback == null) {
            return null;
        }
        return Registries.getId(object, (class_2378)MoreObjects.firstNonNull((Object)((class_2378)class_2378.field_11144.method_10223(fallback.method_29177())), (Object)((class_2378)class_5458.field_25926.method_10223(fallback.method_29177()))));
    }

    @Deprecated
    @Nullable
    public static <T> class_2960 getId(T object, @Nullable class_2378<T> fallback) {
        if (fallback == null) {
            return null;
        }
        return fallback.method_10221(object);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static RegistryProvider _get(String modId) {
        return RegistriesImpl._get(modId);
    }

    public String getModId() {
        return this.modId;
    }

    @ApiStatus.Internal
    public static interface RegistryProvider {
        public <T> Registrar<T> get(class_5321<class_2378<T>> var1);

        @Deprecated
        public <T> Registrar<T> get(class_2378<T> var1);

        public <T> void forRegistry(class_5321<class_2378<T>> var1, Consumer<Registrar<T>> var2);

        public <T> RegistrarBuilder<T> builder(Class<T> var1, class_2960 var2);
    }
}

