/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.utils.EvictingQueue;
import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3108;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5483;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7058;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SpawnReporter {
    public static boolean mock_spawns = false;
    public static Long track_spawns = 0L;
    public static final HashMap<class_5321<class_1937>, Integer> chunkCounts = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Object2LongMap<class_1299>> spawn_stats = new HashMap();
    public static double mobcap_exponent = 0.0;
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_attempts = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> overall_spawn_ticks = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_ticks_full = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_ticks_fail = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_ticks_succ = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_ticks_spawns = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Long> spawn_cap_count = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, EvictingQueue<Pair<class_1299, class_2338>>> spawned_mobs = new HashMap();
    public static final HashMap<class_1311, Integer> spawn_tries = new HashMap();
    public static class_2338 lower_spawning_limit = null;
    public static class_2338 upper_spawning_limit = null;
    public static HashMap<class_1311, Long> local_spawns = null;
    public static HashSet<class_1311> first_chunk_marker = null;
    public static final int MAGIC_NUMBER;

    public static void registerSpawn(class_1308 mob, class_1311 cat, class_2338 pos) {
        if (lower_spawning_limit != null && (lower_spawning_limit.method_10263() > pos.method_10263() || pos.method_10263() > upper_spawning_limit.method_10263() || lower_spawning_limit.method_10264() > pos.method_10264() || pos.method_10264() > upper_spawning_limit.method_10264() || lower_spawning_limit.method_10260() > pos.method_10260() || pos.method_10260() > upper_spawning_limit.method_10260())) {
            return;
        }
        Pair key = Pair.of((Object)mob.field_6002.method_27983(), (Object)cat);
        long count = spawn_stats.get(key).getOrDefault((Object)mob.method_5864(), 0L);
        spawn_stats.get(key).put((Object)mob.method_5864(), count + 1L);
        spawned_mobs.get(key).put((Pair<class_1299, class_2338>)Pair.of((Object)mob.method_5864(), (Object)pos));
        if (!local_spawns.containsKey(cat)) {
            CarpetSettings.LOG.error("Rogue spawn detected for category " + cat.method_6133() + " for mob " + mob.method_5864().method_5897().getString() + ". If you see this message let carpet peeps know about it on github issues.");
            local_spawns.put(cat, 0L);
        }
        local_spawns.put(cat, local_spawns.get(cat) + 1L);
    }

    public static List<class_2561> printMobcapsForDimension(class_3218 world, boolean multiline) {
        class_5321 dim = world.method_27983();
        String name = dim.method_29177().method_12832();
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        if (multiline) {
            lst.add(Messenger.s(String.format("Mobcaps for %s:", name)));
        }
        class_1948.class_5262 lastSpawner = world.method_14178().method_27908();
        Object2IntMap dimCounts = lastSpawner.method_27830();
        int chunkcount = chunkCounts.getOrDefault(dim, -1);
        if (dimCounts == null || chunkcount < 0) {
            lst.add(Messenger.c("g   --UNAVAILABLE--"));
            return lst;
        }
        ArrayList<Object> shortCodes = new ArrayList<Object>();
        for (class_1311 enumcreaturetype : class_1311.values()) {
            int cur = dimCounts.getOrDefault((Object)enumcreaturetype, -1);
            int max = (int)((double)chunkcount * ((double)enumcreaturetype.method_6134() / (double)MAGIC_NUMBER));
            String color = Messenger.heatmap_color(cur, max);
            String mobColor = Messenger.creatureTypeColor(enumcreaturetype);
            if (multiline) {
                int rounds = spawn_tries.get(enumcreaturetype);
                lst.add(Messenger.c(String.format("w   %s: ", enumcreaturetype.method_6133()), cur < 0 ? "g -" : color + " " + cur, "g  / ", mobColor + " " + max, rounds == 1 ? "w " : String.format("gi  (%d rounds/tick)", spawn_tries.get(enumcreaturetype))));
                continue;
            }
            shortCodes.add(color + " " + (Serializable)(cur < 0 ? "-" : Integer.valueOf(cur)));
            shortCodes.add("g /");
            shortCodes.add(mobColor + " " + max);
            shortCodes.add("g ,");
        }
        if (!multiline) {
            if (shortCodes.size() > 0) {
                shortCodes.remove(shortCodes.size() - 1);
                lst.add(Messenger.c(shortCodes.toArray(new Object[0])));
            } else {
                lst.add(Messenger.c("g   --UNAVAILABLE--"));
            }
        }
        return lst;
    }

    public static List<class_2561> recent_spawns(class_1937 world, class_1311 creature_type) {
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        if (track_spawns == 0L) {
            lst.add(Messenger.s("Spawn tracking not started"));
            return lst;
        }
        String type_code = creature_type.method_6133();
        lst.add(Messenger.s(String.format("Recent %s spawns:", type_code)));
        for (Pair pair : spawned_mobs.get(Pair.of((Object)world.method_27983(), (Object)creature_type)).keySet()) {
            lst.add(Messenger.c("w  - ", Messenger.tp("wb", (class_2338)pair.getRight()), String.format("w : %s", ((class_1299)pair.getLeft()).method_5897().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Nothing spawned yet, sorry."));
        }
        return lst;
    }

    public static List<class_2561> show_mobcaps(class_2338 pos, class_3218 worldIn) {
        class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
        if (under == null) {
            if (track_spawns > 0L) {
                return SpawnReporter.tracking_report((class_1937)worldIn);
            }
            return SpawnReporter.printMobcapsForDimension(worldIn, true);
        }
        class_1311 creature_type = SpawnReporter.get_type_code_from_wool_code(under);
        if (creature_type != null) {
            if (track_spawns > 0L) {
                return SpawnReporter.recent_spawns((class_1937)worldIn, creature_type);
            }
            return SpawnReporter.printEntitiesByType(creature_type, (class_1937)worldIn, true);
        }
        if (track_spawns > 0L) {
            return SpawnReporter.tracking_report((class_1937)worldIn);
        }
        return SpawnReporter.printMobcapsForDimension(worldIn, true);
    }

    public static class_1311 get_type_code_from_wool_code(class_1767 color) {
        switch (color) {
            case field_7964: {
                return class_1311.field_6302;
            }
            case field_7942: {
                return class_1311.field_6294;
            }
            case field_7966: {
                return class_1311.field_6300;
            }
            case field_7957: {
                return class_1311.field_6303;
            }
            case field_7955: {
                return class_1311.field_24460;
            }
        }
        return null;
    }

    public static class_1311 get_creature_type_from_code(String type_code) {
        if ("hostile".equalsIgnoreCase(type_code)) {
            return class_1311.field_6302;
        }
        if ("passive".equalsIgnoreCase(type_code)) {
            return class_1311.field_6294;
        }
        if ("water".equalsIgnoreCase(type_code)) {
            return class_1311.field_6300;
        }
        if ("fish".equalsIgnoreCase(type_code)) {
            return class_1311.field_24460;
        }
        if ("ambient".equalsIgnoreCase(type_code)) {
            return class_1311.field_6303;
        }
        return null;
    }

    public static String get_type_string(class_1311 type) {
        return String.format("%s", type);
    }

    public static String get_creature_code_from_string(String str) {
        return SpawnReporter.get_type_string(SpawnReporter.get_creature_type_from_code(str));
    }

    public static List<class_2561> printEntitiesByType(class_1311 cat, class_1937 worldIn, boolean all) {
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        lst.add(Messenger.s(String.format("Loaded entities for %s class:", SpawnReporter.get_type_string(cat))));
        for (class_1297 entity : ((class_3218)worldIn).method_18198(class_5575.method_31795(class_1297.class), e -> e.method_5864().method_5891() == cat)) {
            boolean persistent;
            boolean bl = persistent = entity instanceof class_1308 && (((class_1308)entity).method_5947() || ((class_1308)entity).method_17326());
            if (!all && persistent) continue;
            class_1299 type = entity.method_5864();
            class_2338 pos = entity.method_24515();
            lst.add(Messenger.c("w  - ", Messenger.tp(persistent ? "gb" : "wb", pos), String.format(persistent ? "g : %s" : "w : %s", type.method_5897().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Empty."));
        }
        return lst;
    }

    public static void initialize_mocking() {
        mock_spawns = true;
    }

    public static void stop_mocking() {
        mock_spawns = false;
    }

    public static void reset_spawn_stats(MinecraftServer server, boolean full) {
        spawn_stats.clear();
        spawned_mobs.clear();
        for (class_1311 enumcreaturetype : class_1311.values()) {
            if (full) {
                spawn_tries.put(enumcreaturetype, 1);
            }
            if (server == null) continue;
            for (class_5321 dim : server.method_29435()) {
                Pair key = Pair.of((Object)dim, (Object)enumcreaturetype);
                overall_spawn_ticks.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_attempts.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_ticks_full.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_ticks_fail.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_ticks_succ.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_ticks_spawns.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_cap_count.put((Pair<class_5321<class_1937>, class_1311>)key, 0L);
                spawn_stats.put((Pair<class_5321<class_1937>, class_1311>)key, (Object2LongMap<class_1299>)new Object2LongOpenHashMap());
                spawned_mobs.put((Pair<class_5321<class_1937>, class_1311>)key, new EvictingQueue());
            }
        }
        track_spawns = 0L;
    }

    private static String getWorldCode(class_5321<class_1937> world) {
        if (world == class_1937.field_25179) {
            return "";
        }
        return "(" + world.method_29177().method_12832().toUpperCase(Locale.ROOT).replace("THE_", "").charAt(0) + ")";
    }

    public static List<class_2561> tracking_report(class_1937 worldIn) {
        ArrayList<class_2561> report = new ArrayList<class_2561>();
        if (track_spawns == 0L) {
            report.add(Messenger.c("w Spawn tracking disabled, type '", "wi /spawn tracking start", "/spawn tracking start", "w ' to enable"));
            return report;
        }
        long duration = (long)worldIn.method_8503().method_3780() - track_spawns;
        report.add(Messenger.c("bw --------------------"));
        String simulated = mock_spawns ? "[SIMULATED] " : "";
        String location = lower_spawning_limit != null ? String.format("[in (%d, %d, %d)x(%d, %d, %d)]", lower_spawning_limit.method_10263(), lower_spawning_limit.method_10264(), lower_spawning_limit.method_10260(), upper_spawning_limit.method_10263(), upper_spawning_limit.method_10264(), upper_spawning_limit.method_10260()) : "";
        report.add(Messenger.s(String.format("%sSpawn statistics %s: for %.1f min", simulated, location, (double)duration / 72000.0 * 60.0)));
        for (class_1311 enumcreaturetype : class_1311.values()) {
            for (class_5321 dim : worldIn.method_8503().method_29435()) {
                Pair code = Pair.of((Object)dim, (Object)enumcreaturetype);
                if (spawn_ticks_spawns.get(code) <= 0L) continue;
                double hours = (double)overall_spawn_ticks.get(code).longValue() / 72000.0;
                report.add(Messenger.s(String.format(" > %s%s (%.1f min), %.1f m/t, %%{%.1fF %.1f- %.1f+}; %.2f s/att", enumcreaturetype.method_6133().substring(0, 3), SpawnReporter.getWorldCode((class_5321<class_1937>)dim), 60.0 * hours, 1.0 * (double)spawn_cap_count.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_full.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_fail.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_succ.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 1.0 * (double)spawn_ticks_spawns.get(code).longValue() / (double)(spawn_ticks_fail.get(code) + spawn_ticks_succ.get(code)))));
                for (class_1299 type : spawn_stats.get(code).keySet()) {
                    report.add(Messenger.s(String.format("   - %s: %d spawns, %d per hour", type.method_5897().getString(), spawn_stats.get(code).getLong((Object)type), 72000L * spawn_stats.get(code).getLong((Object)type) / duration)));
                }
            }
        }
        return report;
    }

    public static void killEntity(class_1309 entity) {
        if (entity.method_5765()) {
            entity.method_5854().method_31472();
        }
        if (entity.method_5782()) {
            for (class_1297 e : entity.method_5685()) {
                e.method_31472();
            }
        }
        if (entity instanceof class_3701) {
            for (class_1297 e : entity.method_5770().method_8335((class_1297)entity, entity.method_5829())) {
                e.method_31472();
            }
        }
        entity.method_31472();
    }

    private static List<class_5483.class_1964> getSpawnEntries(class_3218 serverLevel, class_5138 structureManager, class_2794 chunkGenerator, class_1311 mobCategory, class_2338 blockPos, @Nullable class_6880<class_1959> holder) {
        return SpawnReporter.isInNetherFortressBounds(blockPos, serverLevel, mobCategory, structureManager) ? class_3108.field_13705.method_34994() : chunkGenerator.method_12113(holder != null ? holder : serverLevel.method_23753(blockPos), structureManager, mobCategory, blockPos).method_34994();
    }

    public static boolean isInNetherFortressBounds(class_2338 blockPos, class_3218 serverLevel, class_1311 mobCategory, class_5138 structureManager) {
        if (mobCategory == class_1311.field_6302 && serverLevel.method_8320(blockPos.method_10074()).method_27852(class_2246.field_10266)) {
            class_3195 structure = (class_3195)structureManager.method_41036().method_30530(class_2378.field_25915).method_29107(class_7058.field_37182);
            return structure == null ? false : structureManager.method_28388(blockPos, structure).method_16657();
        }
        return false;
    }

    public static List<class_2561> report(class_2338 pos, class_3218 worldIn) {
        ArrayList<class_2561> rep = new ArrayList<class_2561>();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2791 chunk = worldIn.method_22350(pos);
        int lc = chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1;
        String where = String.format(y >= lc ? "%d blocks above it." : "%d blocks below it.", class_3532.method_15382((int)(y - lc)));
        if (y == lc) {
            where = "right at it.";
        }
        rep.add(Messenger.s(String.format("Maximum spawn Y value for (%+d, %+d) is %d. You are " + where, x, z, lc)));
        rep.add(Messenger.s("Spawns:"));
        for (class_1311 enumcreaturetype : class_1311.values()) {
            String type_code = String.format("%s", enumcreaturetype).substring(0, 3);
            List<class_5483.class_1964> lst = SpawnReporter.getSpawnEntries(worldIn, worldIn.method_27056(), worldIn.method_14178().method_12129(), enumcreaturetype, pos, (class_6880<class_1959>)worldIn.method_23753(pos));
            if (lst == null || lst.isEmpty()) continue;
            for (class_5483.class_1964 spawnEntry : lst) {
                class_1308 mob;
                if (class_1317.method_6159((class_1299)spawnEntry.field_9389) == null) continue;
                boolean canspawn = class_1948.method_8660((class_1317.class_1319)class_1317.method_6159((class_1299)spawnEntry.field_9389), (class_4538)worldIn, (class_2338)pos, (class_1299)spawnEntry.field_9389);
                int will_spawn = -1;
                try {
                    mob = (class_1308)spawnEntry.field_9389.method_5883((class_1937)worldIn);
                }
                catch (Exception exception) {
                    CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)exception);
                    return rep;
                }
                boolean fits_true = false;
                boolean fits_false = false;
                if (canspawn) {
                    will_spawn = 0;
                    for (int attempt = 0; attempt < 50; ++attempt) {
                        boolean fits;
                        float f = (float)x + 0.5f;
                        float f1 = (float)z + 0.5f;
                        mob.method_5808((double)f, (double)y, (double)f1, worldIn.field_9229.method_43057() * 360.0f, 0.0f);
                        boolean fits1 = worldIn.method_17892((class_1297)mob);
                        class_1299 etype = mob.method_5864();
                        for (int i = 0; i < 20; ++i) {
                            if (!class_1317.method_20638((class_1299)etype, (class_5425)worldIn, (class_3730)class_3730.field_16459, (class_2338)pos, (class_5819)worldIn.field_9229) || !class_1948.method_8660((class_1317.class_1319)class_1317.method_6159((class_1299)etype), (class_4538)worldIn, (class_2338)pos, (class_1299)etype) || !mob.method_5979((class_1936)worldIn, class_3730.field_16459)) continue;
                            if (etype == class_1299.field_6081) {
                                class_2680 blockState = worldIn.method_8320(pos.method_10074());
                                if (pos.method_10264() < worldIn.method_8615() || !blockState.method_27852(class_2246.field_10219) && !blockState.method_26164(class_3481.field_15503)) continue;
                            }
                            ++will_spawn;
                        }
                        mob.method_5943((class_5425)worldIn, worldIn.method_8404(mob.method_24515()), class_3730.field_16459, null, null);
                        boolean bl = fits = fits1 && worldIn.method_17892((class_1297)mob);
                        if (fits) {
                            fits_true = true;
                        } else {
                            fits_false = true;
                        }
                        SpawnReporter.killEntity((class_1309)mob);
                        try {
                            mob = (class_1308)spawnEntry.field_9389.method_5883((class_1937)worldIn);
                            continue;
                        }
                        catch (Exception exception) {
                            CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)exception);
                            return rep;
                        }
                    }
                }
                String creature_name = mob.method_5864().method_5897().getString();
                String pack_size = String.format("%d", mob.method_5945());
                int weight = spawnEntry.method_34979().method_34976();
                if (canspawn) {
                    String c = fits_true && will_spawn > 0 ? "e" : "gi";
                    rep.add(Messenger.c(String.format("%s %s: %s (%d:%d-%d/%d), can: ", c, type_code, creature_name, weight, spawnEntry.field_9388, spawnEntry.field_9387, mob.method_5945()), "l YES", c + " , fit: ", fits_true && fits_false ? "y YES and NO" : (fits_true ? "l YES" : "r NO"), c + " , will: ", (will_spawn > 0 ? "l " : "r ") + Math.round((double)will_spawn) / 10L + "%"));
                } else {
                    rep.add(Messenger.c(String.format("gi %s: %s (%d:%d-%d/%d), can: ", type_code, creature_name, weight, spawnEntry.field_9388, spawnEntry.field_9387, mob.method_5945()), "n NO"));
                }
                SpawnReporter.killEntity((class_1309)mob);
            }
        }
        return rep;
    }

    static {
        SpawnReporter.reset_spawn_stats(null, true);
        MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    }
}

